/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */
package com.jaspersoft.jasperserver.ws.axis2;

import java.io.IOException;
import javax.activation.DataSource;
import java.io.ByteArrayInputStream;

/**
 * This class is used to transfer file usimg MTOM and SOAP with Attachments
 * @author gtoffoli
 */
public class Axis2ByteArrayDataSource implements DataSource{
    
   private byte[] byteArray = null;
    private String name = "";
    
    /** Creates a new instance of ResourceDataSource */
    public Axis2ByteArrayDataSource(String name, byte[] byteArray) {
        this.name = name;
        this.byteArray = byteArray;
    }

    public java.io.InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(byteArray);
    }

    public java.io.OutputStream getOutputStream() throws IOException {
        throw new java.io.IOException();
    }

    public String getContentType() {
        return "application/octet-stream";
    }

    public String getName() {
        return name;
         
    }
    
}
