/*
// * Copyright (C) 2006 JasperSoft http://www.jaspersoft.com
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed WITHOUT ANY WARRANTY; and without the 
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt 
 * or write to:
 * 
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */

package com.jaspersoft.jasperserver.ws.axis2.repository;

import java.util.Map;

import com.jaspersoft.jasperserver.api.metadata.common.domain.DataType;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.ws.axis2.RepositoryServiceContext;

/**
 * @author gtoffoli
 * @version $Id: DataTypeHandler.java 9304 2007-08-02 16:59:49Z lucian $
 */
public class DataTypeHandler extends RepositoryResourceHandler {

	public Class getResourceType() {
		return DataType.class;
	}

	protected void doDescribe(Resource resource, ResourceDescriptor descriptor,
			Map arguments, RepositoryServiceContext serviceContext) {
		DataType fileResource = (DataType) resource;
		descriptor.setWsType(ResourceDescriptor.TYPE_DATA_TYPE);
		descriptor.setHasData(false);
		descriptor.setIsReference(false);

		descriptor.setDataType(fileResource.getType());
		descriptor.setPattern(fileResource.getRegularExpr());
		// We suppose this field is a String!!!
		descriptor.setMaxValue(fileResource.getMaxValue() == null ? null
				: fileResource.getMaxValue() + "");
		// We suppose this field is a String!!!
		descriptor.setMinValue(fileResource.getMinValue() == null ? null
				: fileResource.getMinValue() + "");
		descriptor.setStrictMax(fileResource.isStrictMax());
		descriptor.setStrictMin(fileResource.isStrictMin());
	}

	protected void updateResource(Resource resource,
			ResourceDescriptor descriptor, RepositoryServiceContext serviceContext) {
		DataType dataType = (DataType) resource;
        // Validations should be done in the save method...
        dataType.setType( descriptor.getDataType());
        dataType.setRegularExpr( descriptor.getPattern() );
        dataType.setMaxValue( descriptor.getMaxValue() );
        dataType.setStrictMax( descriptor.isStrictMax() );
        dataType.setMinValue( descriptor.getMinValue() );
        dataType.setStrictMin(descriptor.isStrictMin() );
	}

}
