/*
 * Copyright (C) 2006 JasperSoft http://www.jaspersoft.com
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed WITHOUT ANY WARRANTY; and without the 
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt 
 * or write to:
 * 
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */

package example.cds;

import org.springframework.validation.Errors;

import com.jaspersoft.jasperserver.api.engine.jasperreports.util.CustomDataSourceValidator;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.CustomReportDataSource;

/**
 * @author bob
 *
 */
public class CustomTestValidator implements CustomDataSourceValidator {

	/* check the values in the map; call rejectValue if tests don't pass
	 */
	public void validatePropertyValues(CustomReportDataSource ds, Errors errors) {
		String foo = null;
		if (ds.getPropertyMap() != null) {
			foo = (String) ds.getPropertyMap().get("foo");
		}
		if (foo == null || foo.length() == 0) {
			// first arg is the path of the property which has the error
			// for custom DS's this will always be in the form "reportDataSource.propertyMap[yourPropName]"
			errors.rejectValue("reportDataSource.propertyMap[foo]", "myCustomDataSource.foo.required");
		}
	}

}
