/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.jca;

import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.BaseOperationCommand;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.SimpleTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.impl.DefaultCompleter;
import org.jboss.as.cli.impl.RequestParamArgWithValue;
import org.jboss.as.cli.impl.RequestParamArgWithoutValue;
import org.jboss.as.cli.impl.RequestParamPropertiesArg;
import org.jboss.as.cli.impl.RequiredRequestParamArg;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.dmr.ModelNode;

public class BaseDataSourceAddHandler
extends BaseOperationCommand {
    private final String dsType;
    private final ArgumentWithValue profile;
    private final ArgumentWithValue jndiName;

    public BaseDataSourceAddHandler(CommandContext ctx, String commandName, String dsType) {
        super(ctx, commandName, true);
        this.dsType = dsType;
        this.profile = new ArgumentWithValue(this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

            public List<String> getAllCandidates(CommandContext ctx) {
                return Util.getNodeNames(ctx.getModelControllerClient(), null, "profile");
            }
        }), "--profile"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (!ctx.isDomainMode()) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.jndiName = new RequiredRequestParamArg("jndi-name", this, "--jndi-name"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (ctx.isDomainMode() && !BaseDataSourceAddHandler.this.profile.isValueComplete(ctx.getParsedCommandLine())) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.initArguments();
        this.addRequiredPath("/subsystem=datasources");
    }

    @Override
    public ModelNode buildRequestWithoutHeaders(CommandContext ctx) throws CommandFormatException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        ParsedCommandLine args = ctx.getParsedCommandLine();
        if (ctx.isDomainMode()) {
            String profile = this.profile.getValue(args);
            if (profile == null) {
                throw new OperationFormatException("--profile argument value is missing.");
            }
            builder.addNode("profile", profile);
        }
        builder.addNode("subsystem", "datasources");
        builder.addNode(this.dsType, this.jndiName.getValue(args, true));
        builder.setOperationName("add");
        this.setParams(ctx, builder.getModelNode());
        return builder.buildRequest();
    }

    private void initArguments() {
        ArgumentWithoutValue lastRequired = this.initRequiredArguments();
        this.initOptionalArguments(lastRequired);
    }

    protected ArgumentWithoutValue initRequiredArguments() {
        RequiredRequestParamArg driverName = new RequiredRequestParamArg("driver-name", (CommandHandlerWithArguments)this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

            public List<String> getAllCandidates(CommandContext ctx) {
                String profileName;
                if (ctx.isDomainMode()) {
                    profileName = BaseDataSourceAddHandler.this.profile.getValue(ctx.getParsedCommandLine());
                    if (profileName == null) {
                        return Collections.emptyList();
                    }
                } else {
                    profileName = null;
                }
                DefaultOperationRequestAddress datasources = new DefaultOperationRequestAddress();
                if (profileName != null) {
                    datasources.toNode("profile", profileName);
                }
                datasources.toNode("subsystem", "datasources");
                return Util.getNodeNames(ctx.getModelControllerClient(), datasources, "jdbc-driver");
            }
        }));
        driverName.addRequiredPreceding(this.jndiName);
        RequiredRequestParamArg poolName = new RequiredRequestParamArg("pool-name", (CommandHandlerWithArguments)this, "--pool-name");
        poolName.addRequiredPreceding(driverName);
        return poolName;
    }

    protected void initOptionalArguments(ArgumentWithoutValue lastRequired) {
        RequestParamArgWithValue username = new RequestParamArgWithValue("user-name", (CommandHandlerWithArguments)this, "--username");
        username.addRequiredPreceding(lastRequired);
        RequestParamArgWithValue password = new RequestParamArgWithValue("password", (CommandHandlerWithArguments)this, "--password");
        password.addRequiredPreceding(lastRequired);
        RequestParamArgWithoutValue useJavaContext = new RequestParamArgWithoutValue("use-java-context", this);
        useJavaContext.addRequiredPreceding(lastRequired);
        RequestParamArgWithValue maxPoolSize = new RequestParamArgWithValue("max-pool-size", this);
        maxPoolSize.addRequiredPreceding(lastRequired);
        RequestParamArgWithValue minPoolSize = new RequestParamArgWithValue("min-pool-size", this);
        minPoolSize.addRequiredPreceding(lastRequired);
        RequestParamArgWithValue disabled = new RequestParamArgWithValue("enabled", this, "--disabled"){

            @Override
            public boolean isValueRequired() {
                return false;
            }

            @Override
            public void set(ParsedCommandLine args, ModelNode request) throws CommandFormatException {
                if (this.isPresent(args)) {
                    5.setValue(request, "enabled", "false");
                }
            }
        };
        disabled.addRequiredPreceding(lastRequired);
        RequestParamArgWithValue newConnectionSql = new RequestParamArgWithValue("new-connection-sql", this);
        newConnectionSql.addRequiredPreceding(lastRequired);
        RequestParamArgWithValue urlDelimiter = new RequestParamArgWithValue("url-delimiter", this);
        urlDelimiter.addRequiredPreceding(lastRequired);
        RequestParamArgWithValue urlSelectorStrategyClass = new RequestParamArgWithValue("url-selector-strategy-class-name", (CommandHandlerWithArguments)this, "--url-selector-strategy-class");
        urlSelectorStrategyClass.addRequiredPreceding(lastRequired);
        RequestParamArgWithoutValue poolPrefill = new RequestParamArgWithoutValue("pool-prefill", this);
        poolPrefill.addRequiredPreceding(lastRequired);
        RequestParamArgWithoutValue poolUseStrictMin = new RequestParamArgWithoutValue("pool-use-strict-min", this);
        poolUseStrictMin.addRequiredPreceding(lastRequired);
        RequestParamArgWithValue flushStrategy = new RequestParamArgWithValue("flush-strategy", (CommandHandlerWithArguments)this, new SimpleTabCompleter(new String[]{"FAILING_CONNECTION_ONLY", "IDLE_CONNECTIONS", "ENTIRE_POOL"}));
        flushStrategy.addRequiredPreceding(lastRequired);
        RequestParamArgWithValue securityDomain = new RequestParamArgWithValue("security-domain", this);
        securityDomain.addRequiredPreceding(lastRequired);
        RequestParamArgWithValue reauthPluginClass = new RequestParamArgWithValue("reauth-plugin-class-name", this);
        reauthPluginClass.addRequiredPreceding(lastRequired);
        RequestParamPropertiesArg reauthPluginProps = new RequestParamPropertiesArg("reauth-plugin-properties", this);
        reauthPluginProps.addRequiredPreceding(reauthPluginClass);
        RequestParamArgWithoutValue sharePreparedStatements = new RequestParamArgWithoutValue("share-prepared-statements", this);
        sharePreparedStatements.addRequiredPreceding(lastRequired);
        RequestParamArgWithValue psCacheSize = new RequestParamArgWithValue("prepared-statements-cacheSize", (CommandHandlerWithArguments)this, "--prepared-statements-cache-size");
        psCacheSize.addRequiredPreceding(lastRequired);
        RequestParamArgWithValue trackStatements = new RequestParamArgWithValue("track-statements", (CommandHandlerWithArguments)this, new SimpleTabCompleter(new String[]{"FALSE", "NOWARN", "TRUE"}));
        trackStatements.addRequiredPreceding(lastRequired);
        RequestParamArgWithValue allocationRetry = new RequestParamArgWithValue("allocation-retry", this);
        allocationRetry.addRequiredPreceding(lastRequired);
        RequestParamArgWithValue allocationRetryWait = new RequestParamArgWithValue("allocation-retry-wait-millis", this);
        allocationRetryWait.addRequiredPreceding(lastRequired);
        RequestParamArgWithValue blockingTimeoutWait = new RequestParamArgWithValue("blocking-timeout-wait-millis", this);
        blockingTimeoutWait.addRequiredPreceding(lastRequired);
        RequestParamArgWithValue idleTimeout = new RequestParamArgWithValue("idle-timeout-minutes", this);
        idleTimeout.addRequiredPreceding(lastRequired);
        RequestParamArgWithValue queryTimeout = new RequestParamArgWithValue("query-timeout", this);
        queryTimeout.addRequiredPreceding(lastRequired);
        RequestParamArgWithValue useTryLock = new RequestParamArgWithValue("use-try-lock", this);
        useTryLock.addRequiredPreceding(lastRequired);
        RequestParamArgWithValue setTxQueryTimeout = new RequestParamArgWithValue("set-tx-query-timeout", this);
        setTxQueryTimeout.addRequiredPreceding(lastRequired);
        RequestParamArgWithValue txIsolation = new RequestParamArgWithValue("transaction-isolation", (CommandHandlerWithArguments)this, new SimpleTabCompleter(new String[]{"TRANSACTION_READ_UNCOMMITTED", "TRANSACTION_READ_COMMITTED", "TRANSACTION_REPEATABLE_READ", "TRANSACTION_SERIALIZABLE", "TRANSACTION_NONE"}));
        txIsolation.addRequiredPreceding(lastRequired);
        RequestParamArgWithValue checkValidConnectionSql = new RequestParamArgWithValue("check-valid-connection-sql", this);
        checkValidConnectionSql.addRequiredPreceding(lastRequired);
        RequestParamArgWithValue exceptionSorterClass = new RequestParamArgWithValue("exception-sorter-class-name", (CommandHandlerWithArguments)this, "--exception-sorter-class");
        exceptionSorterClass.addRequiredPreceding(lastRequired);
        RequestParamPropertiesArg exceptionSorterProps = new RequestParamPropertiesArg("exception-sorter-properties", this);
        exceptionSorterProps.addRequiredPreceding(exceptionSorterClass);
        RequestParamArgWithValue staleConnectionCheckerClass = new RequestParamArgWithValue("stale-connection-checker-class-name", (CommandHandlerWithArguments)this, "--stale-connection-checker-class");
        staleConnectionCheckerClass.addRequiredPreceding(lastRequired);
        RequestParamPropertiesArg staleConnectionCheckerProps = new RequestParamPropertiesArg("stale-connection-checker-properties", this);
        staleConnectionCheckerProps.addRequiredPreceding(staleConnectionCheckerClass);
        RequestParamArgWithValue validConnectionCheckerClass = new RequestParamArgWithValue("valid-connection-checker-class-name", (CommandHandlerWithArguments)this, "--valid-connection-checker-class");
        validConnectionCheckerClass.addRequiredPreceding(lastRequired);
        RequestParamPropertiesArg validConnectionCheckerProps = new RequestParamPropertiesArg("valid-connection-checker-properties", this);
        validConnectionCheckerProps.addRequiredPreceding(validConnectionCheckerClass);
        RequestParamArgWithoutValue backgroundValidation = new RequestParamArgWithoutValue("background-validation", this);
        backgroundValidation.addRequiredPreceding(lastRequired);
        RequestParamArgWithValue backgroundValidationMins = new RequestParamArgWithValue("background-validation-minutes", this);
        backgroundValidationMins.addRequiredPreceding(lastRequired);
        RequestParamArgWithoutValue useFastFail = new RequestParamArgWithoutValue("use-fast-fail", this);
        useFastFail.addRequiredPreceding(lastRequired);
        RequestParamArgWithoutValue validateOnMatch = new RequestParamArgWithoutValue("validate-on-match", this);
        validateOnMatch.addRequiredPreceding(lastRequired);
        RequestParamArgWithoutValue spy = new RequestParamArgWithoutValue("spy", this);
        spy.addRequiredPreceding(lastRequired);
        RequestParamArgWithoutValue useCCM = new RequestParamArgWithoutValue("use-ccm", this);
        useCCM.addRequiredPreceding(lastRequired);
    }
}

