/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutionException;
import javax.crypto.SealedObject;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.client.util.ExceptionHolder;
import org.teiid.client.util.ResultsFuture;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.crypto.CryptoException;
import org.teiid.logging.LogManager;
import org.teiid.net.socket.Message;
import org.teiid.net.socket.ServiceInvocationStruct;
import org.teiid.query.QueryPlugin;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.transport.ClientInstance;
import org.teiid.transport.ClientServiceRegistryImpl;

public class ServerWorkItem
implements Runnable {
    private final ClientInstance socketClientInstance;
    private final Serializable messageKey;
    private final Message message;
    private final ClientServiceRegistryImpl csr;

    public ServerWorkItem(ClientInstance socketClientInstance, Serializable messageKey, Message message, ClientServiceRegistryImpl server) {
        this.socketClientInstance = socketClientInstance;
        this.messageKey = messageKey;
        this.message = message;
        this.csr = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Message result = null;
        String loggingContext = null;
        final boolean encrypt = this.message.getContents() instanceof SealedObject;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Object methodResult;
            try {
                Thread.currentThread().setContextClassLoader(this.csr.getCallerClassloader());
            }
            catch (Throwable t) {
                // empty catch block
            }
            this.message.setContents(this.socketClientInstance.getCryptor().unsealObject(this.message.getContents()));
            if (!(this.message.getContents() instanceof ServiceInvocationStruct)) {
                throw new AssertionError((Object)"unknown message contents");
            }
            ServiceInvocationStruct serviceStruct = (ServiceInvocationStruct)this.message.getContents();
            final ClientServiceRegistryImpl.ClientService clientService = this.csr.getClientService(serviceStruct.targetClass.getName());
            loggingContext = clientService.getLoggingContext();
            Method m = clientService.getReflectionHelper().findBestMethodOnTarget(serviceStruct.methodName, serviceStruct.args);
            try {
                methodResult = m.invoke(clientService.getInstance(), serviceStruct.args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            if (ResultsFuture.class.isAssignableFrom(m.getReturnType()) && methodResult != null) {
                ResultsFuture future = (ResultsFuture)methodResult;
                future.addCompletionListener((ResultsFuture.CompletionListener)new ResultsFuture.CompletionListener<Object>(){

                    public void onCompletion(ResultsFuture<Object> completedFuture) {
                        Message asynchResult = new Message();
                        try {
                            asynchResult.setContents(completedFuture.get());
                        }
                        catch (InterruptedException e) {
                            asynchResult.setContents((Object)ServerWorkItem.this.processException(e, clientService.getLoggingContext()));
                        }
                        catch (ExecutionException e) {
                            asynchResult.setContents((Object)ServerWorkItem.this.processException(e.getCause(), clientService.getLoggingContext()));
                        }
                        ServerWorkItem.this.sendResult(asynchResult, encrypt);
                    }
                });
            } else {
                Message resultHolder = new Message();
                resultHolder.setContents(methodResult);
                result = resultHolder;
            }
        }
        catch (Throwable t) {
            Message holder = new Message();
            holder.setContents((Object)this.processException(t, loggingContext));
            result = holder;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        if (result != null) {
            this.sendResult(result, encrypt);
        }
    }

    void sendResult(Message result, boolean encrypt) {
        if (encrypt) {
            try {
                result.setContents(this.socketClientInstance.getCryptor().sealObject(result.getContents()));
            }
            catch (CryptoException e) {
                throw new TeiidRuntimeException((BundleUtil.Event)RuntimePlugin.Event.TEIID40071, (Throwable)e);
            }
        }
        this.socketClientInstance.send(result, this.messageKey);
    }

    private Serializable processException(Throwable e, String context) {
        if (context == null) {
            context = "org.teiid.TRANSPORT";
        }
        if (e instanceof TeiidProcessingException) {
            this.logProcessingException(e, context);
        } else if (e instanceof AdminProcessingException) {
            this.logProcessingException(e, context);
        } else {
            LogManager.logError((String)context, (Throwable)e, (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40017, new Object[]{this.socketClientInstance.getWorkContext().getSessionId()}));
        }
        return new ExceptionHolder(e);
    }

    private void logProcessingException(Throwable e, String context) {
        Throwable cause;
        for (cause = e; cause.getCause() != null && cause != cause.getCause(); cause = cause.getCause()) {
        }
        StackTraceElement elem = cause.getStackTrace()[0];
        String msg = RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40011, new Object[]{e.getMessage(), this.socketClientInstance.getWorkContext().getSessionId(), e.getClass().getName(), elem});
        if (LogManager.isMessageToBeRecorded((String)context, (int)5)) {
            LogManager.logWarning((String)context, (Throwable)e, (Object)msg);
        } else {
            LogManager.logWarning((String)context, (Object)(msg + QueryPlugin.Util.getString("stack_info")));
        }
    }
}

