/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.TimeoutException;
import org.jgroups.util.Promise;

public class AckCollector {
    protected final List<Address> missing_acks;
    protected final Promise<Boolean> all_acks_received = new Promise();
    protected final List<Address> suspected_mbrs = new ArrayList<Address>(5);
    protected int expected_acks;

    public AckCollector() {
        this.missing_acks = new ArrayList<Address>();
        this.expected_acks = 0;
    }

    public AckCollector(Collection<Address> members) {
        this.missing_acks = new ArrayList<Address>(members != null ? members.size() : 10);
        this.addAll(members);
    }

    public AckCollector(Address ... members) {
        this.missing_acks = new ArrayList<Address>(members != null ? members.length : 10);
        this.addAll(members);
    }

    public synchronized void reset(Collection<Address> members) {
        this.suspected_mbrs.clear();
        this.missing_acks.clear();
        this.addAll(members);
        this.all_acks_received.reset();
    }

    public synchronized int size() {
        return this.missing_acks.size();
    }

    public synchronized int expectedAcks() {
        return this.expected_acks;
    }

    public synchronized void ack(Address member) {
        if (member != null && this.missing_acks.remove(member) && this.missing_acks.isEmpty()) {
            this.all_acks_received.setResult(Boolean.TRUE);
        }
    }

    public synchronized void suspect(Address member) {
        if (member == null) {
            return;
        }
        if (!this.suspected_mbrs.contains(member)) {
            this.suspected_mbrs.add(member);
        }
        this.ack(member);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(Collection<Address> members) {
        if (members == null) {
            return false;
        }
        boolean retval = false;
        AckCollector ackCollector = this;
        synchronized (ackCollector) {
            this.suspected_mbrs.retainAll(members);
            retval = this.missing_acks.retainAll(members);
            if (retval && this.missing_acks.isEmpty()) {
                this.all_acks_received.setResult(Boolean.TRUE);
            }
        }
        return retval;
    }

    public boolean waitForAllAcks() {
        if (this.missing_acks.isEmpty()) {
            return true;
        }
        Boolean result = this.all_acks_received.getResult();
        return result != null && result != false;
    }

    public boolean waitForAllAcks(long timeout) throws TimeoutException {
        if (this.missing_acks.isEmpty()) {
            return true;
        }
        Boolean result = this.all_acks_received.getResultWithTimeout(timeout);
        return result != null && result != false;
    }

    public String toString() {
        return this.suspected_mbrs.isEmpty() ? this.printMissing() : this.printMissing() + " (suspected: " + this.printSuspected() + ")";
    }

    public synchronized String printMissing() {
        return this.missing_acks.toString();
    }

    public synchronized String printSuspected() {
        return this.suspected_mbrs.toString();
    }

    protected synchronized void addAll(Address ... members) {
        if (members == null) {
            return;
        }
        for (Address member : members) {
            if (member == null || this.missing_acks.contains(member)) continue;
            this.missing_acks.add(member);
        }
        this.expected_acks = this.missing_acks.size();
    }

    protected synchronized void addAll(Collection<Address> members) {
        if (members == null) {
            return;
        }
        for (Address member : members) {
            if (member == null || this.missing_acks.contains(member)) continue;
            this.missing_acks.add(member);
        }
        this.expected_acks = this.missing_acks.size();
    }
}

