/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRCalculable;
import net.sf.jasperreports.engine.fill.JRLongIncrementerFactory;

final class JRLongSumIncrementer
extends JRAbstractExtendedIncrementer {
    private static JRLongSumIncrementer mainInstance = new JRLongSumIncrementer();

    private JRLongSumIncrementer() {
    }

    public static JRLongSumIncrementer getInstance() {
        return mainInstance;
    }

    @Override
    public Object increment(JRCalculable variable, Object expressionValue, AbstractValueProvider valueProvider) {
        Number value = (Number)variable.getIncrementedValue();
        Number newValue = (Number)expressionValue;
        if (newValue == null) {
            if (variable.isInitialized()) {
                return null;
            }
            return value;
        }
        if (value == null || variable.isInitialized()) {
            value = JRLongIncrementerFactory.ZERO;
        }
        return new Long(value.longValue() + newValue.longValue());
    }

    @Override
    public Object initialValue() {
        return JRLongIncrementerFactory.ZERO;
    }
}

