/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.JRDataUtils;

public final class WebUtil {
    public static final String PROPERTY_REQUEST_PARAMETER_REPORT_URI = "net.sf.jasperreports.web.request.parameter.report.uri";
    public static final String PROPERTY_REQUEST_PARAMETER_RUN_REPORT = "net.sf.jasperreports.web.request.parameter.run.report";
    public static final String PROPERTY_REQUEST_PARAMETER_ASYNC_REPORT = "net.sf.jasperreports.web.request.parameter.async.report";
    public static final String PROPERTY_REQUEST_PARAMETER_RESOURCE_URI = "net.sf.jasperreports.web.request.parameter.resource.uri";
    public static final String PROPERTY_REQUEST_PARAMETER_RESOURCE_LOCALE = "net.sf.jasperreports.web.request.parameter.resource.locale";
    public static final String PROPERTY_REQUEST_PARAMETER_RESOURCE_BUNDLE = "net.sf.jasperreports.web.request.parameter.resource.bundle";
    public static final String PROPERTY_REQUEST_PARAMETER_DYNAMIC_RESOURCE = "net.sf.jasperreports.web.request.parameter.dynamic.resource";
    public static final String PROPERTY_REPORT_EXECUTION_PATH = "net.sf.jasperreports.web.report.execution.path";
    public static final String PROPERTY_REPORT_INTERACTION_PATH = "net.sf.jasperreports.web.report.interaction.path";
    public static final String PROPERTY_REPORT_RESOURCES_PATH = "net.sf.jasperreports.web.report.resources.path";
    public static final String RESOURCE_JR_GLOBAL_JS = "net/sf/jasperreports/web/servlets/resources/jasperreports-global.js";
    public static final String RESOURCE_JR_GLOBAL_CSS = "net/sf/jasperreports/web/servlets/resources/jasperreports-global.css";
    private JasperReportsContext jasperReportsContext;

    private WebUtil(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    public static WebUtil getInstance(JasperReportsContext jasperReportsContext) {
        return new WebUtil(jasperReportsContext);
    }

    public String getReportExecutionPath() {
        String path = JRPropertiesUtil.getInstance(this.jasperReportsContext).getProperty(PROPERTY_REPORT_EXECUTION_PATH);
        if (path == null) {
            throw new JRRuntimeException("Configuration property 'net.sf.jasperreports.web.report.execution.path' is not set.");
        }
        return path;
    }

    public String getReportInteractionPath() {
        String path = JRPropertiesUtil.getInstance(this.jasperReportsContext).getProperty(PROPERTY_REPORT_INTERACTION_PATH);
        if (path == null) {
            throw new JRRuntimeException("Configuration property 'net.sf.jasperreports.web.report.interaction.path' is not set.");
        }
        return path;
    }

    public String getResourcesPath() {
        String path = JRPropertiesUtil.getInstance(this.jasperReportsContext).getProperty(PROPERTY_REPORT_RESOURCES_PATH);
        if (path == null) {
            throw new JRRuntimeException("Configuration property 'net.sf.jasperreports.web.report.resources.path' is not set.");
        }
        return path;
    }

    public String getResourceUri(HttpServletRequest request) {
        String resourceUriParamName = JRPropertiesUtil.getInstance(this.jasperReportsContext).getProperty(PROPERTY_REQUEST_PARAMETER_RESOURCE_URI);
        return request.getParameter(resourceUriParamName);
    }

    public Locale getResourceLocale(HttpServletRequest request) {
        String resourceLocaleParamName = JRPropertiesUtil.getInstance(this.jasperReportsContext).getProperty(PROPERTY_REQUEST_PARAMETER_RESOURCE_LOCALE);
        String localeCode = request.getParameter(resourceLocaleParamName);
        return localeCode == null ? null : JRDataUtils.getLocale(localeCode);
    }

    public String getResourceBundleForResource(HttpServletRequest request) {
        String resourceBundleParamName = JRPropertiesUtil.getInstance(this.jasperReportsContext).getProperty(PROPERTY_REQUEST_PARAMETER_RESOURCE_BUNDLE);
        return request.getParameter(resourceBundleParamName);
    }

    public boolean isDynamicResource(HttpServletRequest request) {
        String dynamicResourceParamName = JRPropertiesUtil.getInstance(this.jasperReportsContext).getProperty(PROPERTY_REQUEST_PARAMETER_DYNAMIC_RESOURCE);
        return Boolean.parseBoolean(request.getParameter(dynamicResourceParamName));
    }

    public String getResourcesBasePath() {
        String resourcesBasePath = this.getResourcesPath();
        String resourceUriParamName = JRPropertiesUtil.getInstance(this.jasperReportsContext).getProperty(PROPERTY_REQUEST_PARAMETER_RESOURCE_URI);
        return resourcesBasePath + "?" + resourceUriParamName + "=";
    }

    public String getResourcePath(String resourcePath) {
        return this.getResourcePath(this.getResourcesBasePath(), resourcePath, false);
    }

    public String getResourcePath(String resourcePath, boolean isDynamic) {
        return this.getResourcePath(this.getResourcesBasePath(), resourcePath, isDynamic);
    }

    public String getResourcePath(String resourcesBasePath, String resourcePath) {
        return this.getResourcePath(resourcesBasePath, resourcePath, false);
    }

    public String getResourcePath(String resourcesBasePath, String resourcePath, boolean isDynamic) {
        String resourceDynamicParamName = JRPropertiesUtil.getInstance(this.jasperReportsContext).getProperty(PROPERTY_REQUEST_PARAMETER_DYNAMIC_RESOURCE);
        return resourcesBasePath + resourcePath + (isDynamic ? "&" + resourceDynamicParamName + "=" + isDynamic : "");
    }

    public String getResourcePath(String resourcesBasePath, String resourcePath, String resourceBundleName, Locale locale) {
        String resourceBundleParamName = JRPropertiesUtil.getInstance(this.jasperReportsContext).getProperty(PROPERTY_REQUEST_PARAMETER_RESOURCE_BUNDLE);
        String resourceLocaleParamName = JRPropertiesUtil.getInstance(this.jasperReportsContext).getProperty(PROPERTY_REQUEST_PARAMETER_RESOURCE_LOCALE);
        return this.getResourcePath(resourcesBasePath, resourcePath, false) + "&" + resourceBundleParamName + "=" + resourceBundleName + "&" + resourceLocaleParamName + "=" + JRDataUtils.getLocaleCode(locale);
    }

    public static String encodeUrl(String url) {
        if (url != null) {
            try {
                return URLEncoder.encode(url, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new JRRuntimeException(e);
            }
        }
        return null;
    }

    public static String decodeUrl(String url) {
        if (url != null) {
            try {
                return URLDecoder.decode(url, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new JRRuntimeException(e);
            }
        }
        return null;
    }
}

