/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent.locks;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.Lock;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.transaction.xa.GlobalTransaction;

@ThreadSafe
public class OwnableReentrantLock
extends AbstractQueuedSynchronizer
implements Lock {
    private static final long serialVersionUID = 4932974734462848792L;
    private transient Object owner;
    private final ThreadLocal<Object> requestorOnStack = new ThreadLocal();

    protected final Object currentRequestor() {
        Object cr = this.requestorOnStack.get();
        if (cr == null) {
            throw new IllegalStateException("Should never get to this state!");
        }
        return cr;
    }

    private void setCurrentRequestor(Object requestor) {
        this.requestorOnStack.set(requestor);
    }

    public void unsetCurrentRequestor() {
        this.requestorOnStack.remove();
    }

    @Override
    public void lock() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unlock() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(GlobalTransaction requestor) {
        this.setCurrentRequestor(requestor);
        try {
            if (this.compareAndSetState(0, 1)) {
                this.owner = requestor;
            } else {
                this.acquire(1);
            }
        }
        finally {
            this.unsetCurrentRequestor();
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.acquireInterruptibly(1);
    }

    @Override
    public boolean tryLock() {
        return this.tryAcquire(1);
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException("Should never get here");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryLock(Object requestor, long time, TimeUnit unit) throws InterruptedException {
        this.setCurrentRequestor(requestor);
        try {
            boolean bl = this.tryAcquireNanos(1, unit.toNanos(time));
            return bl;
        }
        finally {
            this.unsetCurrentRequestor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(Object requestor) {
        this.setCurrentRequestor(requestor);
        try {
            this.release(1);
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
        }
        finally {
            this.unsetCurrentRequestor();
        }
    }

    @Override
    public AbstractQueuedSynchronizer.ConditionObject newCondition() {
        throw new UnsupportedOperationException("Not supported in this implementation!");
    }

    @Override
    protected final boolean tryAcquire(int acquires) {
        Object current = this.currentRequestor();
        int c = this.getState();
        if (c == 0) {
            if (this.compareAndSetState(0, acquires)) {
                this.owner = current;
                return true;
            }
        } else if (current.equals(this.owner)) {
            this.setState(c + acquires);
            return true;
        }
        return false;
    }

    @Override
    protected final boolean tryRelease(int releases) {
        int c = this.getState() - releases;
        if (!this.currentRequestor().equals(this.owner)) {
            return false;
        }
        boolean free = false;
        if (c == 0) {
            free = true;
            this.owner = null;
        }
        this.setState(c);
        return free;
    }

    @Override
    protected final boolean isHeldExclusively() {
        return this.getState() != 0 && this.currentRequestor().equals(this.owner);
    }

    public final Object getOwner() {
        int c = this.getState();
        Object o = this.owner;
        return c == 0 ? null : o;
    }

    public final int getHoldCount(Object requestor) {
        int c = this.getState();
        Object o = this.owner;
        return requestor.equals(o) ? c : 0;
    }

    public final boolean isLocked() {
        return this.getState() != 0;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.setState(0);
    }

    @Override
    public String toString() {
        Object owner = this.getOwner();
        return super.toString() + (owner == null ? "[Unlocked]" : "[Locked by " + owner + "]");
    }
}

