/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.database.transaction.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.unitils.core.Unitils;
import org.unitils.core.UnitilsException;
import org.unitils.database.transaction.UnitilsTransactionManager;
import org.unitils.database.transaction.impl.UnitilsTransactionManagementConfiguration;
import org.unitils.spring.SpringModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultUnitilsTransactionManager
implements UnitilsTransactionManager {
    private static Log logger = LogFactory.getLog(DefaultUnitilsTransactionManager.class);
    protected Map<Object, Boolean> testObjectTransactionActiveMap = new HashMap<Object, Boolean>();
    protected Map<Object, TransactionStatus> testObjectTransactionStatusMap = new HashMap<Object, TransactionStatus>();
    protected Map<Object, PlatformTransactionManager> testObjectPlatformTransactionManagerMap = new HashMap<Object, PlatformTransactionManager>();
    protected List<UnitilsTransactionManagementConfiguration> transactionManagementConfigurations;

    @Override
    public void init(Set<UnitilsTransactionManagementConfiguration> transactionManagementConfigurations) {
        this.setTransactionManagementConfigurations(transactionManagementConfigurations);
    }

    @Override
    public DataSource getTransactionalDataSource(DataSource dataSource) {
        return new TransactionAwareDataSourceProxy(dataSource);
    }

    @Override
    public void startTransaction(Object testObject) {
        UnitilsTransactionManagementConfiguration transactionManagementConfiguration = this.getTransactionManagementConfiguration(testObject);
        if (transactionManagementConfiguration.isTransactionalResourceAvailable(testObject)) {
            this.testObjectTransactionActiveMap.put(testObject, Boolean.TRUE);
            this.doStartTransaction(testObject, transactionManagementConfiguration);
        } else {
            this.testObjectTransactionActiveMap.put(testObject, Boolean.FALSE);
        }
    }

    @Override
    public void activateTransactionIfNeeded(Object testObject) {
        if (this.testObjectTransactionActiveMap.containsKey(testObject) && !this.testObjectTransactionActiveMap.get(testObject).booleanValue()) {
            this.testObjectTransactionActiveMap.put(testObject, Boolean.TRUE);
            UnitilsTransactionManagementConfiguration transactionManagementConfiguration = this.getTransactionManagementConfiguration(testObject);
            this.doStartTransaction(testObject, transactionManagementConfiguration);
        }
    }

    protected void doStartTransaction(Object testObject, UnitilsTransactionManagementConfiguration transactionManagementConfiguration) {
        logger.debug((Object)"Starting transaction");
        PlatformTransactionManager platformTransactionManager = transactionManagementConfiguration.getSpringPlatformTransactionManager(testObject);
        this.testObjectPlatformTransactionManagerMap.put(testObject, platformTransactionManager);
        TransactionStatus transactionStatus = platformTransactionManager.getTransaction(this.createTransactionDefinition(testObject));
        this.testObjectTransactionStatusMap.put(testObject, transactionStatus);
    }

    @Override
    public void commit(Object testObject) {
        if (!this.testObjectTransactionActiveMap.containsKey(testObject)) {
            throw new UnitilsException("Trying to commit, while no transaction is currently active");
        }
        TransactionStatus transactionStatus = this.testObjectTransactionStatusMap.get(testObject);
        if (this.testObjectTransactionActiveMap.get(testObject).booleanValue()) {
            logger.debug((Object)"Committing transaction");
            this.testObjectPlatformTransactionManagerMap.get(testObject).commit(transactionStatus);
        }
        this.testObjectTransactionActiveMap.remove(testObject);
        this.testObjectTransactionStatusMap.remove(testObject);
        this.testObjectPlatformTransactionManagerMap.remove(testObject);
    }

    @Override
    public void rollback(Object testObject) {
        if (!this.testObjectTransactionActiveMap.containsKey(testObject)) {
            throw new UnitilsException("Trying to rollback, while no transaction is currently active");
        }
        TransactionStatus transactionStatus = this.testObjectTransactionStatusMap.get(testObject);
        if (this.testObjectTransactionActiveMap.get(testObject).booleanValue()) {
            logger.debug((Object)"Rolling back transaction");
            this.testObjectPlatformTransactionManagerMap.get(testObject).rollback(transactionStatus);
        }
        this.testObjectTransactionActiveMap.remove(testObject);
        this.testObjectTransactionStatusMap.remove(testObject);
        this.testObjectPlatformTransactionManagerMap.remove(testObject);
    }

    protected TransactionDefinition createTransactionDefinition(Object testObject) {
        return new DefaultTransactionDefinition(0);
    }

    protected UnitilsTransactionManagementConfiguration getTransactionManagementConfiguration(Object testObject) {
        for (UnitilsTransactionManagementConfiguration transactionManagementConfiguration : this.transactionManagementConfigurations) {
            if (!transactionManagementConfiguration.isApplicableFor(testObject)) continue;
            return transactionManagementConfiguration;
        }
        throw new UnitilsException("No applicable transaction management configuration found for test " + testObject.getClass());
    }

    protected void setTransactionManagementConfigurations(Set<UnitilsTransactionManagementConfiguration> transactionManagementConfigurationsSet) {
        ArrayList<UnitilsTransactionManagementConfiguration> configurations = new ArrayList<UnitilsTransactionManagementConfiguration>();
        configurations.addAll(transactionManagementConfigurationsSet);
        Collections.sort(configurations, new Comparator<UnitilsTransactionManagementConfiguration>(){

            @Override
            public int compare(UnitilsTransactionManagementConfiguration o1, UnitilsTransactionManagementConfiguration o2) {
                return o2.getPreference().compareTo(o1.getPreference());
            }
        });
        this.transactionManagementConfigurations = configurations;
    }

    protected SpringModule getSpringModule() {
        return Unitils.getInstance().getModulesRepository().getModuleOfType(SpringModule.class);
    }
}

