/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.mock.core;

import java.lang.reflect.Method;
import java.util.List;
import org.unitils.mock.argumentmatcher.ArgumentMatcher;
import org.unitils.mock.mockbehavior.MockBehavior;
import org.unitils.mock.mockbehavior.ValidatableMockBehavior;
import org.unitils.mock.proxy.ProxyInvocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BehaviorDefiningInvocation
extends ProxyInvocation {
    private String mockName;
    private List<ArgumentMatcher> argumentMatchers;
    private MockBehavior mockBehavior;
    private boolean used;

    public BehaviorDefiningInvocation(Object proxy, String mockName, Method method, List<Object> arguments, List<Object> argumentsAtInvocationTime, StackTraceElement invokedAt, List<ArgumentMatcher> argumentMatchers, MockBehavior mockBehavior) {
        super(proxy, method, arguments, argumentsAtInvocationTime, invokedAt);
        this.mockName = mockName;
        this.argumentMatchers = argumentMatchers;
        this.mockBehavior = mockBehavior;
        this.used = false;
        if (mockBehavior instanceof ValidatableMockBehavior) {
            ((ValidatableMockBehavior)mockBehavior).assertCanExecute(this);
        }
    }

    public String getMockName() {
        return this.mockName;
    }

    public List<ArgumentMatcher> getArgumentMatchers() {
        return this.argumentMatchers;
    }

    public MockBehavior getMockBehavior() {
        return this.mockBehavior;
    }

    public boolean isUsed() {
        return this.used;
    }

    public void markAsUsed() {
        this.used = true;
    }

    public boolean matches(ProxyInvocation proxyInvocation) {
        if (!this.getMethod().equals(proxyInvocation.getMethod())) {
            return false;
        }
        List<Object> arguments = proxyInvocation.getArguments();
        List<Object> argumentsAtInvocationTime = proxyInvocation.getArgumentsAtInvocationTime();
        if (arguments.size() != this.argumentMatchers.size()) {
            return false;
        }
        for (int i = 0; i < arguments.size(); ++i) {
            Object argument = arguments.get(i);
            Object argumentAtInvocationTime = argumentsAtInvocationTime.get(i);
            if (this.argumentMatchers.get(i).matches(argument, argumentAtInvocationTime)) continue;
            return false;
        }
        return true;
    }
}

