/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.maven.surefire.report.AbstractFileReporter;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.Reporter;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.util.NestedRuntimeException;

public class ConsoleOutputFileReporter
implements Reporter {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final File reportsDirectory;
    private PrintWriter printWriter = null;
    private String reportEntryName;
    private ReportEntry report;
    private final String reportNameSuffix;

    public ConsoleOutputFileReporter(File reportsDirectory) {
        this(reportsDirectory, null);
    }

    public ConsoleOutputFileReporter(File reportsDirectory, String reportNameSuffix) {
        this.reportsDirectory = reportsDirectory;
        this.reportNameSuffix = reportNameSuffix;
    }

    public void testSetStarting(ReportEntry reportEntry) {
        this.reportEntryName = reportEntry.getName();
    }

    public void testSetCompleted(ReportEntry report) throws ReporterException {
        if (this.printWriter != null) {
            this.printWriter.close();
            this.printWriter = null;
        }
    }

    public void writeMessage(byte[] b, int off, int len) {
        try {
            if (this.printWriter == null) {
                if (!this.reportsDirectory.exists()) {
                    this.reportsDirectory.mkdirs();
                }
                File file = AbstractFileReporter.getReportFile(this.reportsDirectory, this.reportEntryName, this.reportNameSuffix, "-output.txt");
                this.printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            }
            this.printWriter.write(new String(b, off, len));
            this.printWriter.write(LINE_SEPARATOR);
        }
        catch (IOException e) {
            throw new NestedRuntimeException(e);
        }
    }

    public void testStarting(ReportEntry report) {
    }

    public void testSucceeded(ReportEntry report) {
    }

    public void testSkipped(ReportEntry report) {
    }

    public void testError(ReportEntry report, String stdOut, String stdErr) {
    }

    public void testFailed(ReportEntry report, String stdOut, String stdErr) {
    }

    public void writeMessage(String message) {
    }

    public void reset() {
    }
}

