/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.Closeable;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.jboss.logging.Logger;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;
import org.xnio.channels.UnsupportedOptionException;
import org.xnio.nio.NioHandle;
import org.xnio.nio.NioTcpChannel;
import org.xnio.nio.NioXnioWorker;
import org.xnio.nio.SelectorUtils;
import org.xnio.nio.WorkerThread;

final class NioTcpServer
implements AcceptingChannel<NioTcpChannel> {
    private static final Logger log = Logger.getLogger((String)"org.xnio.nio.tcp.server");
    private static final String FQCN = NioTcpServer.class.getName();
    private final NioXnioWorker worker;
    private final ChannelListener.SimpleSetter<NioTcpServer> acceptSetter = new ChannelListener.SimpleSetter();
    private final ChannelListener.SimpleSetter<NioTcpServer> closeSetter = new ChannelListener.SimpleSetter();
    private final List<NioHandle<NioTcpServer>> acceptHandles;
    private final ServerSocketChannel channel;
    private final ServerSocket socket;
    private static final Set<Option<?>> options = Option.setBuilder().add(Options.REUSE_ADDRESSES).add(Options.RECEIVE_BUFFER).add(Options.SEND_BUFFER).add(Options.KEEP_ALIVE).add(Options.TCP_OOB_INLINE).add(Options.TCP_NODELAY).create();
    private volatile int keepAlive;
    private volatile int oobInline;
    private volatile int tcpNoDelay;
    private volatile int sendBuffer = -1;
    private static final AtomicIntegerFieldUpdater<NioTcpServer> keepAliveUpdater = AtomicIntegerFieldUpdater.newUpdater(NioTcpServer.class, "keepAlive");
    private static final AtomicIntegerFieldUpdater<NioTcpServer> oobInlineUpdater = AtomicIntegerFieldUpdater.newUpdater(NioTcpServer.class, "oobInline");
    private static final AtomicIntegerFieldUpdater<NioTcpServer> tcpNoDelayUpdater = AtomicIntegerFieldUpdater.newUpdater(NioTcpServer.class, "tcpNoDelay");
    private static final AtomicIntegerFieldUpdater<NioTcpServer> sendBufferUpdater = AtomicIntegerFieldUpdater.newUpdater(NioTcpServer.class, "sendBuffer");

    NioTcpServer(NioXnioWorker worker, ServerSocketChannel channel, OptionMap optionMap) throws ClosedChannelException {
        this.worker = worker;
        this.channel = channel;
        boolean write = optionMap.get(Options.WORKER_ESTABLISH_WRITING, false);
        int count = optionMap.get(Options.WORKER_ACCEPT_THREADS, 1);
        WorkerThread[] threads = worker.choose(count, write);
        NioHandle[] handles = new NioHandle[threads.length];
        int length = threads.length;
        for (int i = 0; i < length; ++i) {
            handles[i] = threads[i].addChannel(channel, this, 0, this.acceptSetter);
        }
        this.acceptHandles = Arrays.asList(handles);
        this.socket = channel.socket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.channel.close();
        }
        finally {
            for (NioHandle<NioTcpServer> handle : this.acceptHandles) {
                handle.cancelKey();
            }
        }
    }

    public boolean supportsOption(Option<?> option) {
        return options.contains(option);
    }

    public <T> T getOption(Option<T> option) throws UnsupportedOptionException, IOException {
        if (option == Options.REUSE_ADDRESSES) {
            return (T)option.cast((Object)this.socket.getReuseAddress());
        }
        if (option == Options.RECEIVE_BUFFER) {
            return (T)option.cast((Object)this.socket.getReceiveBufferSize());
        }
        if (option == Options.SEND_BUFFER) {
            int value = this.sendBuffer;
            return (T)(value == -1 ? null : option.cast((Object)value));
        }
        if (option == Options.KEEP_ALIVE) {
            return (T)option.cast((Object)(this.keepAlive != 0 ? 1 : 0));
        }
        if (option == Options.TCP_OOB_INLINE) {
            return (T)option.cast((Object)(this.oobInline != 0 ? 1 : 0));
        }
        if (option == Options.TCP_NODELAY) {
            return (T)option.cast((Object)(this.tcpNoDelay != 0 ? 1 : 0));
        }
        return null;
    }

    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        Comparable<Boolean> old;
        if (option == Options.REUSE_ADDRESSES) {
            old = this.socket.getReuseAddress();
            this.socket.setReuseAddress((Boolean)Options.REUSE_ADDRESSES.cast(value));
        } else if (option == Options.RECEIVE_BUFFER) {
            old = this.socket.getReceiveBufferSize();
            this.socket.setReceiveBufferSize((Integer)Options.RECEIVE_BUFFER.cast(value));
        } else if (option == Options.SEND_BUFFER) {
            int newValue;
            int n = newValue = value == null ? -1 : (Integer)Options.SEND_BUFFER.cast(value);
            if (value != null && newValue < 1) {
                throw new IllegalArgumentException("Bad send buffer size specified");
            }
            int oldValue = sendBufferUpdater.getAndSet(this, newValue);
            old = oldValue == -1 ? null : Integer.valueOf(oldValue);
        } else if (option == Options.KEEP_ALIVE) {
            old = keepAliveUpdater.getAndSet(this, (Boolean)Options.KEEP_ALIVE.cast(value) != false ? 1 : 0) != 0;
        } else if (option == Options.TCP_OOB_INLINE) {
            old = oobInlineUpdater.getAndSet(this, (Boolean)Options.TCP_OOB_INLINE.cast(value) != false ? 1 : 0) != 0;
        } else if (option == Options.TCP_NODELAY) {
            old = tcpNoDelayUpdater.getAndSet(this, (Boolean)Options.TCP_NODELAY.cast(value) != false ? 1 : 0) != 0;
        } else {
            return null;
        }
        return (T)option.cast((Object)old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NioTcpChannel accept() throws IOException {
        NioTcpChannel newChannel;
        SocketChannel accepted = this.channel.accept();
        if (accepted == null) {
            return null;
        }
        accepted.configureBlocking(false);
        Socket socket = accepted.socket();
        socket.setKeepAlive(this.keepAlive != 0);
        socket.setOOBInline(this.oobInline != 0);
        socket.setTcpNoDelay(this.tcpNoDelay != 0);
        int sendBuffer = this.sendBuffer;
        if (sendBuffer > 0) {
            socket.setSendBufferSize(sendBuffer);
        }
        boolean ok = false;
        try {
            newChannel = new NioTcpChannel(this.worker, accepted);
            ok = true;
        }
        finally {
            if (!ok) {
                IoUtils.safeClose((Closeable)accepted);
            }
        }
        log.trace((Object)"TCP server accepted connection");
        return newChannel;
    }

    public String toString() {
        return String.format("TCP server (NIO) <%s>", Integer.toHexString(this.hashCode()));
    }

    public ChannelListener.SimpleSetter<NioTcpServer> getAcceptSetter() {
        return this.acceptSetter;
    }

    public ChannelListener.SimpleSetter<NioTcpServer> getCloseSetter() {
        return this.closeSetter;
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public SocketAddress getLocalAddress() {
        return this.socket.getLocalSocketAddress();
    }

    public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
        SocketAddress address = this.getLocalAddress();
        return (A)(type.isInstance(address) ? (SocketAddress)type.cast(address) : null);
    }

    public void suspendAccepts() {
        for (NioHandle<NioTcpServer> handle : this.acceptHandles) {
            handle.resume(0);
        }
    }

    public void resumeAccepts() {
        for (NioHandle<NioTcpServer> handle : this.acceptHandles) {
            handle.resume(16);
        }
    }

    public void wakeupAccepts() {
        log.logf(FQCN, Logger.Level.TRACE, null, "Wake up accepts on %s", (Object)this);
        this.resumeAccepts();
        List<NioHandle<NioTcpServer>> handles = this.acceptHandles;
        int len = handles.size();
        if (len == 0) {
            throw new IllegalArgumentException("No thread configured");
        }
        int idx = IoUtils.getThreadLocalRandom().nextInt(len);
        this.acceptHandles.get(idx).execute();
    }

    public void awaitAcceptable() throws IOException {
        SelectorUtils.await(this.worker.getXnio(), this.channel, 16);
    }

    public void awaitAcceptable(long time, TimeUnit timeUnit) throws IOException {
        SelectorUtils.await(this.worker.getXnio(), this.channel, 16, time, timeUnit);
    }

    public XnioWorker getWorker() {
        return this.worker;
    }
}

