/*
 * Decompiled with CFR 0.152.
 */
package jmxlogger.tools;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import jmxlogger.tools.JmxConfigStore;
import jmxlogger.tools.JmxLogEmitterMBean;
import jmxlogger.tools.ToolBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxLogEmitter
extends NotificationBroadcasterSupport
implements JmxLogEmitterMBean {
    private volatile boolean started = false;
    private AtomicLong count = new AtomicLong(0L);
    private Date startDate;
    private JmxConfigStore configStore;
    private String logLevel;
    private String filterExp;
    private Map<String, Long> statistics;

    public JmxLogEmitter(JmxConfigStore store) {
        this.configStore = store;
        this.initializeBean();
    }

    private void initializeBean() {
        this.configStore.addListener(new JmxConfigStore.ConfigEventListener(){

            public void onValueChanged(JmxConfigStore.ConfigEvent event) {
                if (!event.getSource().equals(JmxLogEmitter.this) && event.getKey().equals("level")) {
                    JmxLogEmitter.this.logLevel = (String)event.getValue();
                }
                if (!event.getSource().equals(JmxLogEmitter.this) && event.getKey().equals("filterExpression")) {
                    JmxLogEmitter.this.filterExp = (String)event.getValue();
                }
            }
        });
    }

    @Override
    public synchronized void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        this.startDate = new Date();
    }

    @Override
    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
    }

    @Override
    public synchronized boolean isStarted() {
        return this.started;
    }

    @Override
    public String getStartDate() {
        return new SimpleDateFormat().format(this.startDate);
    }

    @Override
    public long getLogCount() {
        return this.count.longValue();
    }

    @Override
    public long getStats(String key) {
        return this.statistics.get(key);
    }

    public void sendLog(Map<String, Object> event) {
        if (!this.started) {
            throw new IllegalStateException("JmxLogEmitter must be started before you can invoke sendLog().");
        }
        this.sendNotification(this.buildNotification(event));
        this.count.incrementAndGet();
    }

    private Notification buildNotification(Map<String, Object> event) {
        long seqnum = event.get("sequenceNumber") != null ? (Long)event.get("sequenceNumber") : 0L;
        long timestamp = event.get("timestamp") != null ? (Long)event.get("timestamp") : 0L;
        this.statistics = (Map)event.get("logStats");
        Notification note = new Notification(ToolBox.getDefaultEventType(), (String)event.get("source"), seqnum, timestamp, (String)event.get("formattedMessage"));
        note.setUserData(event);
        return note;
    }

    @Override
    public void setLevel(String level) {
        this.logLevel = level;
        this.configStore.putValue("level", level);
        this.configStore.postEvent(new JmxConfigStore.ConfigEvent(this, "level", level));
    }

    @Override
    public String getLevel() {
        return this.logLevel;
    }

    @Override
    public String getFilterExpression() {
        return this.filterExp;
    }

    @Override
    public void setFilterExpression(String exp) {
        this.filterExp = exp;
        this.configStore.putValue("filterExpression", this.filterExp);
        this.configStore.postEvent(new JmxConfigStore.ConfigEvent(this, "filterExpression", this.filterExp));
    }

    @Override
    public String getFilterScriptFile() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setFilterScriptFile(String file) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

