/*
 * Decompiled with CFR 0.152.
 */
package jmxlogger.tools;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import jmxlogger.tools.JmxLogFilter;
import jmxlogger.tools.ToolBox;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxScriptedLogFilter
implements JmxLogFilter {
    private Serializable expression;
    private ParserContext context = new ParserContext();
    private File scriptFile;

    public JmxScriptedLogFilter() {
        this.context.addPackageImport("java.util");
    }

    public void setFilterExpression(String exp) {
        this.expression = exp == null || exp.length() == 0 ? null : MVEL.compileExpression((String)exp, (ParserContext)this.context);
    }

    public void setScriptFile(File f) {
        if (!ToolBox.isFileValid(f)) {
            throw new IllegalStateException(String.format("File [%s] is not a valid file.", f));
        }
        this.scriptFile = f;
    }

    @Override
    public boolean isLogAllowed(Map<String, Object> event) {
        Object result = new Boolean("false");
        if (this.scriptFile != null) {
            try {
                result = MVEL.evalFile((File)this.scriptFile, event);
            }
            catch (IOException ex) {
                throw new IllegalStateException("JmxScriptedLogFilter - unable to access script file: " + ex.getMessage());
            }
        } else {
            result = this.expression == null ? new Boolean("true") : MVEL.executeExpression((Object)this.expression, event);
        }
        if (!(result instanceof Boolean)) {
            throw new IllegalStateException("Filter expession must evaluate to a Boolean result.");
        }
        return (Boolean)result;
    }

    public String toString() {
        return (String)((Object)this.expression);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JmxScriptedLogFilter)) {
            return false;
        }
        JmxScriptedLogFilter other = (JmxScriptedLogFilter)obj;
        return this.expression.equals(other.expression);
    }

    public int hashCode() {
        int hash = 3;
        hash = 83 * hash + (this.expression != null ? this.expression.hashCode() : 0);
        return hash;
    }
}

