/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.jdbc.DrvConn;
import com.ingres.gcf.jdbc.DrvObj;
import com.ingres.gcf.jdbc.JdbcRSMD;
import com.ingres.gcf.jdbc.SqlParse;
import com.ingres.gcf.util.SqlEx;

class DrvPrep
extends DrvObj {
    private int refCount = 0;
    private String query = null;
    private JdbcRSMD rsmd = null;
    private String stmtName = null;
    private String tableName = null;
    private int concurrency = -1;

    public DrvPrep(DrvConn drvConn, String string, String string2) throws SqlEx {
        super(drvConn);
        this.title = this.trace.getTraceName() + "-DrvPrep[" + this.inst_id + "]";
        this.tr_id = "DrvPrep[" + this.inst_id + "]";
        try {
            SqlParse sqlParse = new SqlParse(string, drvConn);
            this.query = sqlParse.parseSQL(true);
            this.concurrency = sqlParse.getConcurrency();
            this.tableName = sqlParse.getTableName();
        }
        catch (SqlEx sqlEx) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": error parsing statement text");
            }
            throw sqlEx;
        }
        this.stmtName = string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() throws SqlEx {
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ": preparing statement '" + this.query + "'");
        }
        this.msg.lock();
        try {
            this.msg.begin((byte)4);
            this.msg.write((short)3);
            this.msg.write((short)3);
            this.msg.write(this.stmtName);
            this.writeQueryText(this.query);
            this.msg.done(true);
            this.rsmd = this.readResults();
        }
        finally {
            this.msg.unlock();
        }
    }

    public JdbcRSMD getMetaData() {
        return this.rsmd;
    }

    public String getStmtName() {
        return this.stmtName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public void attach() {
        ++this.refCount;
    }

    public void detach() {
        if (this.refCount > 0) {
            --this.refCount;
        }
    }

    public boolean isActive() {
        return this.refCount > 0;
    }

    protected JdbcRSMD readDesc() throws SqlEx {
        return JdbcRSMD.load(this.conn);
    }
}

