/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.jdbc.DrvTrace;
import com.ingres.gcf.jdbc.JdbcCPConn;
import com.ingres.gcf.jdbc.JdbcConn;
import com.ingres.gcf.jdbc.JdbcXAVirt;
import com.ingres.gcf.jdbc.XARsrcMgr;
import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.SqlEx;
import com.ingres.gcf.util.XaEx;
import com.ingres.gcf.util.XaXid;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class JdbcXAConn
extends JdbcCPConn
implements XAConnection,
XAResource,
GcfErr {
    private XARsrcMgr xarm = null;
    private String user = null;
    private String password = null;
    private XaXid xid = null;
    private boolean autoCommit = false;
    private XactPool suspended = new XactPool();
    private static final Xid[] noXIDs = new Xid[0];

    JdbcXAConn(JdbcConn jdbcConn, XARsrcMgr xARsrcMgr, String string, String string2, DrvTrace drvTrace) throws SQLException {
        super(jdbcConn, drvTrace);
        this.xarm = xARsrcMgr;
        this.user = string;
        this.password = string2;
        this.title = drvTrace.getTraceName() + "-XAConnection[" + this.inst_id + "]";
        this.tr_id = "XAConn[" + this.inst_id + "]";
    }

    public Connection getConnection() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getConnection()");
        }
        if (this.physConn == null) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": physical connection is closed");
            }
            throw SqlEx.get(ERR_GC4004_CONNECTION_CLOSED);
        }
        if (this.xid == null) {
            this.physConn.setAutoCommit(true);
        }
        this.clearConnection();
        this.virtConn = new JdbcXAVirt(this.physConn, this, this, this.trace, this.xid != null);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getConnection(): " + this.virtConn);
        }
        return this.virtConn;
    }

    public void close() throws SQLException {
        Object[] objectArray;
        if (this.physConn != null && this.xid != null) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".close()");
            }
            if (this.trace.enabled(2)) {
                this.trace.write(this.tr_id + ".close: abort active transaction " + this.xid + " on " + this.physConn);
            }
            try {
                this.physConn.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.xarm.deregisterXID(this, this.xid);
            this.xid = null;
        }
        super.close();
        while ((objectArray = this.suspended.remove()) != null) {
            XaXid xaXid = (XaXid)objectArray[0];
            JdbcConn jdbcConn = (JdbcConn)objectArray[1];
            if (this.trace.enabled(3)) {
                this.trace.write(this.tr_id + ".close: abort suspended transaction " + xaXid + " on " + jdbcConn);
            }
            try {
                jdbcConn.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.xarm.deregisterXID(this, xaXid);
            if (this.trace.enabled(3)) {
                this.trace.write(this.tr_id + ".close: close suspended connection " + jdbcConn);
            }
            try {
                jdbcConn.close();
            }
            catch (Exception exception) {}
        }
    }

    public XAResource getXAResource() throws SQLException {
        if (this.physConn == null) {
            throw SqlEx.get(ERR_GC4004_CONNECTION_CLOSED);
        }
        return this;
    }

    public boolean isSameRM(XAResource xAResource) {
        if (xAResource instanceof JdbcXAConn) {
            return this.xarm == ((JdbcXAConn)xAResource).xarm;
        }
        return false;
    }

    public void start(Xid xid, int n) throws XAException {
        XaXid xaXid = xid instanceof XaXid ? (XaXid)xid : new XaXid(xid);
        boolean bl = false;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".start( '" + xaXid + "', 0x" + Integer.toHexString(n) + " )");
        }
        if (this.physConn == null) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".start: connection closed");
            }
            throw new XAException(-6);
        }
        switch (n) {
            case 0: {
                break;
            }
            case 0x200000: {
                bl = true;
                break;
            }
            case 0x8000000: {
                this.resume(xaXid);
                return;
            }
            default: {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ".start: unsupported flags - 0x" + Integer.toHexString(n));
                }
                throw new XAException(-5);
            }
        }
        if (this.xid != null) {
            if (this.trace.enabled(3)) {
                this.trace.write(this.tr_id + ".start: end active transaction " + this.xid + " on " + this.physConn);
            }
            try {
                this.physConn.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.xarm.deregisterXID(this, this.xid);
            this.xid = null;
            if (this.virtConn != null) {
                ((JdbcXAVirt)this.virtConn).setActiveDTX(false);
            }
        }
        try {
            if (this.trace.enabled(3)) {
                this.trace.write(this.tr_id + ".start: issuing request on " + this.physConn);
            }
            this.autoCommit = this.virtConn != null ? this.physConn.getAutoCommit() : false;
            this.physConn.setAutoCommit(false);
            if (bl) {
                this.physConn.startTransaction(xaXid, 0x200000);
            } else {
                this.physConn.startTransaction(xaXid);
            }
            this.xid = xaXid;
        }
        catch (XaEx xaEx) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".start: XA error starting transaction - " + xaEx.getErrorCode());
            }
            throw new XAException(xaEx.getErrorCode());
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".start: error starting transaction");
                ((SqlEx)sQLException).trace(this.trace);
            }
            boolean bl2 = true;
            try {
                bl2 = this.physConn.isClosed();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw new XAException(bl2 ? -7 : -3);
        }
        try {
            this.xarm.registerXID(this, this.xid);
        }
        catch (XAException xAException) {
            try {
                this.physConn.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.xid = null;
            throw xAException;
        }
        if (this.virtConn != null) {
            ((JdbcXAVirt)this.virtConn).setActiveDTX(true);
        }
    }

    public void end(Xid xid, int n) throws XAException {
        XaXid xaXid = xid instanceof XaXid ? (XaXid)xid : new XaXid(xid);
        boolean bl = true;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".end( '" + xaXid + "', 0x" + Integer.toHexString(n) + " )");
        }
        if (this.physConn == null) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".end: connection closed");
            }
            throw new XAException(-6);
        }
        switch (n) {
            case 0x4000000: {
                break;
            }
            case 0x20000000: {
                bl = false;
                break;
            }
            case 0x2000000: {
                this.suspend(xaXid);
                return;
            }
            default: {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ".end: unsupported flags - 0x" + Integer.toHexString(n));
                }
                throw new XAException(-5);
            }
        }
        if (this.xid == null || !xaXid.equals(this.xid)) {
            this.endSuspended(xaXid, bl);
            return;
        }
        try {
            if (this.trace.enabled(3)) {
                this.trace.write(this.tr_id + ".end: issuing request on " + this.physConn);
            }
            if (bl) {
                this.physConn.endTransaction(xaXid);
            } else {
                this.physConn.endTransaction(xaXid, 0x20000000);
            }
            this.physConn.setAutoCommit(this.autoCommit);
        }
        catch (XaEx xaEx) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".end: XA error ending transaction - " + xaEx.getErrorCode());
            }
            throw new XAException(xaEx.getErrorCode());
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".end: error ending transaction");
                ((SqlEx)sQLException).trace(this.trace);
            }
            boolean bl2 = true;
            try {
                bl2 = this.physConn.isClosed();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw new XAException(bl2 ? -7 : -3);
        }
        finally {
            this.xarm.deregisterXID(this, this.xid);
            this.xid = null;
            if (this.virtConn != null) {
                ((JdbcXAVirt)this.virtConn).setActiveDTX(false);
            }
        }
    }

    private void endSuspended(XaXid xaXid, boolean bl) throws XAException {
        JdbcConn jdbcConn = this.suspended.remove(xaXid);
        if (jdbcConn == null) {
            if (this.trace.enabled(2)) {
                this.trace.write(this.tr_id + ".end: passing request to XARM");
            }
            this.xarm.endXID(xaXid, bl ? 0x4000000 : 0x20000000);
            return;
        }
        try {
            if (this.trace.enabled(3)) {
                this.trace.write(this.tr_id + ".end: issuing request on " + jdbcConn);
            }
            if (bl) {
                jdbcConn.endTransaction(xaXid);
            } else {
                jdbcConn.endTransaction(xaXid, 0x20000000);
            }
        }
        catch (XaEx xaEx) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".end: XA error ending transaction - " + xaEx.getErrorCode());
            }
            throw new XAException(xaEx.getErrorCode());
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".end: error ending transaction");
                ((SqlEx)sQLException).trace(this.trace);
            }
            boolean bl2 = true;
            try {
                bl2 = this.physConn.isClosed();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw new XAException(bl2 ? -7 : -3);
        }
        finally {
            this.xarm.deregisterXID(this, xaXid);
            if (this.trace.enabled(3)) {
                this.trace.write(this.tr_id + ".end: close suspended connection " + jdbcConn);
            }
            try {
                jdbcConn.close();
            }
            catch (Exception exception) {}
        }
    }

    private void suspend(XaXid xaXid) throws XAException {
        JdbcConn jdbcConn;
        if (this.trace.enabled(2)) {
            this.trace.log(this.tr_id + ".suspend( '" + xaXid + "' )");
        }
        if (this.xid == null || !xaXid.equals(this.xid)) {
            JdbcConn jdbcConn2 = this.suspended.remove(xaXid);
            if (jdbcConn2 != null) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ".suspend: XID is already suspended");
                }
                this.suspended.add(xaXid, jdbcConn2);
                throw new XAException(-6);
            }
            if (this.trace.enabled(2)) {
                this.trace.write(this.tr_id + ".suspend: passing request to XARM");
            }
            this.xarm.endXID(xaXid, 0x2000000);
            return;
        }
        try {
            jdbcConn = this.xarm.getRMConnection(this.user, this.password);
            jdbcConn.setAutoCommit(this.autoCommit);
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".end: error ending transaction");
                ((SqlEx)sQLException).trace(this.trace);
            }
            boolean bl = true;
            try {
                bl = this.physConn.isClosed();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw new XAException(bl ? -7 : -3);
        }
        if (this.trace.enabled(3)) {
            this.trace.log(this.tr_id + ".suspend: activating " + jdbcConn);
        }
        this.suspended.add(this.xid, this.physConn);
        this.physConn = jdbcConn;
        this.xid = null;
        if (this.virtConn != null) {
            ((JdbcXAVirt)this.virtConn).setConnection(this.physConn);
            ((JdbcXAVirt)this.virtConn).setActiveDTX(false);
        }
    }

    private void resume(XaXid xaXid) throws XAException {
        JdbcConn jdbcConn;
        if (this.trace.enabled(2)) {
            this.trace.log(this.tr_id + ".resume( '" + xaXid + "' )");
        }
        if ((jdbcConn = this.suspended.remove(xaXid)) == null) {
            if (this.trace.enabled(2)) {
                this.trace.write(this.tr_id + ".resume: passing request to XARM");
            }
            this.xarm.startXID(xaXid, 0x8000000);
            return;
        }
        if (this.xid != null) {
            if (this.trace.enabled(3)) {
                this.trace.write(this.tr_id + ".resume: end active transaction " + this.xid + " on " + this.physConn);
            }
            try {
                this.physConn.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.xarm.deregisterXID(this, this.xid);
            this.xid = null;
            if (this.virtConn != null) {
                ((JdbcXAVirt)this.virtConn).setActiveDTX(false);
            }
        }
        if (this.trace.enabled(3)) {
            this.trace.write(this.tr_id + ".resume: close active connection " + this.physConn);
        }
        try {
            this.physConn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.trace.enabled(3)) {
            this.trace.log(this.tr_id + ".resume: activating " + jdbcConn);
        }
        this.physConn = jdbcConn;
        this.xid = xaXid;
        if (this.virtConn != null) {
            ((JdbcXAVirt)this.virtConn).setConnection(this.physConn);
            ((JdbcXAVirt)this.virtConn).setActiveDTX(true);
        }
    }

    public int prepare(Xid xid) throws XAException {
        XaXid xaXid;
        XaXid xaXid2 = xaXid = xid instanceof XaXid ? (XaXid)xid : new XaXid(xid);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".prepare( '" + xaXid + "' )");
        }
        if (this.xid != null && xaXid.equals(this.xid)) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".prepare: XID is active!");
            }
            throw new XAException(-6);
        }
        if (this.physConn == null || this.xid != null) {
            if (this.trace.enabled(2)) {
                this.trace.write(this.tr_id + ".prepare: passing request to XARM");
            }
            return this.xarm.prepareXID(xaXid);
        }
        try {
            this.physConn.prepareTransaction(xaXid);
        }
        catch (XaEx xaEx) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".prepare: XA error preparing transaction - " + xaEx.getErrorCode());
            }
            throw new XAException(xaEx.getErrorCode());
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".prepare: error preparing transaction");
                ((SqlEx)sQLException).trace(this.trace);
            }
            boolean bl = true;
            try {
                bl = this.physConn.isClosed();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw new XAException(bl ? -7 : -3);
        }
        return 0;
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        XaXid xaXid;
        XaXid xaXid2 = xaXid = xid instanceof XaXid ? (XaXid)xid : new XaXid(xid);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".commit( '" + xaXid + "', " + bl + " )");
        }
        if (this.xid != null && xaXid.equals(this.xid)) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".commit: XID is active!");
            }
            throw new XAException(-6);
        }
        if (this.physConn == null || this.xid != null) {
            if (this.trace.enabled(2)) {
                this.trace.write(this.tr_id + ".commit: passing request to XARM");
            }
            this.xarm.commitXID(xaXid, bl);
            return;
        }
        try {
            if (bl) {
                this.physConn.commit(xaXid, 0x40000000);
            } else {
                this.physConn.commit(xaXid);
            }
        }
        catch (XaEx xaEx) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".commit: XA error committing transaction - " + xaEx.getErrorCode());
            }
            throw new XAException(xaEx.getErrorCode());
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".commit: error committing transaction");
                ((SqlEx)sQLException).trace(this.trace);
            }
            boolean bl2 = true;
            try {
                bl2 = this.physConn.isClosed();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw new XAException(bl2 ? -7 : -3);
        }
    }

    public void rollback(Xid xid) throws XAException {
        JdbcConn jdbcConn;
        XaXid xaXid;
        XaXid xaXid2 = xaXid = xid instanceof XaXid ? (XaXid)xid : new XaXid(xid);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".rollback( '" + xaXid + "' )");
        }
        if ((jdbcConn = this.suspended.remove(xaXid)) != null) {
            if (this.trace.enabled(2)) {
                this.trace.write(this.tr_id + ".rollback: aborting suspended transaction " + xid + " on " + jdbcConn);
            }
            try {
                jdbcConn.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.xarm.deregisterXID(this, xaXid);
            if (this.trace.enabled(3)) {
                this.trace.write(this.tr_id + ".rollback: close suspended connection " + jdbcConn);
            }
            try {
                jdbcConn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        if (this.physConn == null || this.xid != null) {
            if (this.trace.enabled(2)) {
                this.trace.write(this.tr_id + ".rollback(): passing request to XARM");
            }
            this.xarm.rollbackXID(xaXid);
            return;
        }
        try {
            this.physConn.rollback(xaXid);
        }
        catch (XaEx xaEx) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".rollback: XA error rolling back xact - " + xaEx.getErrorCode());
            }
            throw new XAException(xaEx.getErrorCode());
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".rollback(): error aborting transaction");
                ((SqlEx)sQLException).trace(this.trace);
            }
            boolean bl = true;
            try {
                bl = this.physConn.isClosed();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw new XAException(bl ? -7 : -3);
        }
    }

    public Xid[] recover(int n) throws XAException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".recover()");
        }
        if ((n & 0x1000000) == 0) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".recover: no XIDs (non-start request)");
            }
            return noXIDs;
        }
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ".recover(): passing request to XARM");
        }
        return this.xarm.recoverXID();
    }

    public void forget(Xid xid) throws XAException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".forget(): not supported!");
        }
        throw new XAException(-4);
    }

    public int getTransactionTimeout() {
        return 0;
    }

    public boolean setTransactionTimeout(int n) {
        return false;
    }

    private static class XactPool {
        private Vector pool = new Vector();

        private XactPool() {
        }

        public boolean empty() {
            return this.pool.isEmpty();
        }

        public synchronized void add(XaXid xaXid, JdbcConn jdbcConn) {
            Object[] objectArray = new Object[]{xaXid, jdbcConn};
            this.pool.add(objectArray);
        }

        public synchronized Object[] remove() {
            Object[] objectArray = null;
            int n = this.pool.size();
            if (n > 0) {
                try {
                    objectArray = (Object[])this.pool.remove(n - 1);
                }
                catch (Exception exception) {
                    objectArray = null;
                }
            }
            return objectArray;
        }

        public synchronized JdbcConn remove(XaXid xaXid) {
            try {
                for (int i = 0; i < this.pool.size(); ++i) {
                    Object[] objectArray = (Object[])this.pool.get(i);
                    if (!xaXid.equals((XaXid)objectArray[0])) continue;
                    this.pool.remove(i);
                    return (JdbcConn)objectArray[1];
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }
}

