/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlDates;
import com.ingres.gcf.util.SqlEx;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.TimeZone;

public class SqlString
extends SqlData {
    private String value = null;

    public SqlString() {
        super(true);
    }

    public SqlString(String string) {
        super(false);
        this.value = string;
    }

    public void set(String string) {
        this.setNotNull();
        this.value = string;
    }

    public void set(SqlString sqlString) {
        if (sqlString == null || sqlString.isNull()) {
            this.setNull();
        } else {
            this.setNotNull();
            this.value = sqlString.value;
        }
    }

    public String get() {
        return this.value;
    }

    public void setBoolean(boolean bl) throws SqlEx {
        this.setString(Boolean.toString(bl));
    }

    public void setByte(byte by) throws SqlEx {
        this.setString(Byte.toString(by));
    }

    public void setShort(short s) throws SqlEx {
        this.setString(Short.toString(s));
    }

    public void setInt(int n) throws SqlEx {
        this.setString(Integer.toString(n));
    }

    public void setLong(long l) throws SqlEx {
        this.setString(Long.toString(l));
    }

    public void setFloat(float f) throws SqlEx {
        this.setString(Float.toString(f));
    }

    public void setDouble(double d) throws SqlEx {
        this.setString(Double.toString(d));
    }

    public void setBigDecimal(BigDecimal bigDecimal) throws SqlEx {
        if (bigDecimal == null) {
            this.setNull();
        } else {
            this.setString(bigDecimal.toString());
        }
    }

    public void setString(String string) throws SqlEx {
        if (string == null) {
            this.setNull();
        } else {
            this.setNotNull();
            this.value = string;
        }
    }

    public void setDate(java.sql.Date date, TimeZone timeZone) throws SqlEx {
        if (date == null) {
            this.setNull();
        } else if (timeZone != null) {
            this.setString(SqlDates.formatDate((Date)date, timeZone));
        } else {
            this.setString(SqlDates.formatDate((Date)date, false));
        }
    }

    public void setTime(Time time, TimeZone timeZone) throws SqlEx {
        if (time == null) {
            this.setNull();
        } else if (timeZone != null) {
            this.setString(SqlDates.formatTime((Date)time, timeZone));
        } else {
            this.setString(SqlDates.formatTime((Date)time, false));
        }
    }

    public void setTimestamp(Timestamp timestamp, TimeZone timeZone) throws SqlEx {
        if (timestamp == null) {
            this.setNull();
        } else if (timeZone != null) {
            this.setString(SqlDates.formatTimestamp((Date)timestamp, timeZone));
        } else {
            this.setString(SqlDates.formatTimestamp((Date)timestamp, false));
        }
    }

    public boolean getBoolean() throws SqlEx {
        String string = this.value.trim();
        return string.equals("1") ? true : Boolean.valueOf(string);
    }

    public byte getByte() throws SqlEx {
        byte by;
        try {
            by = Byte.parseByte(this.value.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
        }
        return by;
    }

    public short getShort() throws SqlEx {
        short s;
        try {
            s = Short.parseShort(this.value.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
        }
        return s;
    }

    public int getInt() throws SqlEx {
        int n;
        try {
            n = Integer.parseInt(this.value.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
        }
        return n;
    }

    public long getLong() throws SqlEx {
        long l;
        try {
            l = Long.parseLong(this.value.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
        }
        return l;
    }

    public float getFloat() throws SqlEx {
        float f;
        try {
            f = Float.parseFloat(this.value.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
        }
        return f;
    }

    public double getDouble() throws SqlEx {
        double d;
        try {
            d = Double.parseDouble(this.value.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
        }
        return d;
    }

    public BigDecimal getBigDecimal() throws SqlEx {
        BigDecimal bigDecimal;
        try {
            bigDecimal = new BigDecimal(this.value.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
        }
        return bigDecimal;
    }

    public String getString() throws SqlEx {
        return this.value;
    }

    public String getString(int n) throws SqlEx {
        return n < this.value.length() ? this.value.substring(0, n) : this.value;
    }

    public java.sql.Date getDate(TimeZone timeZone) throws SqlEx {
        return timeZone == null ? SqlDates.parseDate(this.value.trim(), false) : SqlDates.parseDate(this.value.trim(), timeZone);
    }

    public Time getTime(TimeZone timeZone) throws SqlEx {
        return timeZone == null ? SqlDates.parseTime(this.value.trim(), false) : SqlDates.parseTime(this.value.trim(), timeZone);
    }

    public Timestamp getTimestamp(TimeZone timeZone) throws SqlEx {
        return timeZone == null ? SqlDates.parseTimestamp(this.value.trim(), false) : SqlDates.parseTimestamp(this.value.trim(), timeZone);
    }

    public InputStream getAsciiStream() throws SqlEx {
        return SqlString.getAscii(this.value);
    }

    public InputStream getUnicodeStream() throws SqlEx {
        return SqlString.getUnicode(this.value);
    }

    public Reader getCharacterStream() throws SqlEx {
        return SqlString.getCharacter(this.value);
    }

    public Object getObject() throws SqlEx {
        return this.getString();
    }

    public Object getObject(int n) throws SqlEx {
        return this.getString(n);
    }
}

