/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.chart;

import java.awt.Font;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryAxis3D;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberAxis3D;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.labels.StandardPieToolTipGenerator;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.MultiplePiePlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.AreaRenderer;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.category.StackedAreaRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer3D;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.chart.urls.PieURLGenerator;
import org.jfree.chart.urls.StandardXYURLGenerator;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.util.TableOrder;

public class ChartFactory {
    static String urlPrefix = "";

    public static JFreeChart createPieChart(String title, Font titleFont, CategoryDataset data, TableOrder order, boolean legend, boolean tooltips, boolean urls, PieURLGenerator urlGenerator) {
        MultiplePiePlot plot = new MultiplePiePlot(data);
        plot.setDataExtractOrder(order);
        PiePlot pp = (PiePlot)plot.getPieChart().getPlot();
        pp.setBackgroundPaint(null);
        pp.setOutlineStroke(null);
        StandardPieToolTipGenerator tooltipGenerator = null;
        if (tooltips) {
            tooltipGenerator = new StandardPieToolTipGenerator();
        }
        if (!urls) {
            urlGenerator = null;
        }
        pp.setToolTipGenerator((PieToolTipGenerator)tooltipGenerator);
        pp.setLabelGenerator(null);
        pp.setURLGenerator(urlGenerator);
        JFreeChart chart = new JFreeChart(title, titleFont, (Plot)plot, legend);
        return chart;
    }

    public static JFreeChart create3DPieChart(String title, Font titleFont, CategoryDataset data, TableOrder order, boolean legend, boolean tooltips, boolean urls, PieURLGenerator urlGenerator) {
        MultiplePiePlot plot = new MultiplePiePlot(data);
        plot.setDataExtractOrder(order);
        JFreeChart pieChart = new JFreeChart((Plot)new PiePlot3D(null));
        pieChart.setBackgroundPaint(null);
        plot.setPieChart(pieChart);
        PiePlot3D pp = (PiePlot3D)plot.getPieChart().getPlot();
        pp.setBackgroundPaint(null);
        pp.setOutlineStroke(null);
        StandardPieToolTipGenerator tooltipGenerator = null;
        if (tooltips) {
            tooltipGenerator = new StandardPieToolTipGenerator();
        }
        if (!urls) {
            urlGenerator = null;
        }
        pp.setToolTipGenerator((PieToolTipGenerator)tooltipGenerator);
        pp.setLabelGenerator(null);
        pp.setURLGenerator(urlGenerator);
        JFreeChart chart = new JFreeChart(title, titleFont, (Plot)plot, legend);
        return chart;
    }

    public static JFreeChart createBarChart(String title, Font titleFont, String categoryAxisLabel, String valueAxisLabel, CategoryDataset data, PlotOrientation orientation, boolean legend, boolean tooltips, boolean urls, CategoryURLGenerator urlGenerator) {
        CategoryAxis categoryAxis = new CategoryAxis(categoryAxisLabel);
        NumberAxis valueAxis = new NumberAxis(valueAxisLabel);
        BarRenderer renderer = new BarRenderer();
        if (tooltips) {
            renderer.setToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        }
        if (urls) {
            renderer.setItemURLGenerator(urlGenerator);
        }
        CategoryPlot plot = new CategoryPlot(data, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(orientation);
        JFreeChart chart = new JFreeChart(title, titleFont, (Plot)plot, legend);
        return chart;
    }

    public static JFreeChart createBarChart3D(String title, Font titleFont, String categoryAxisLabel, String valueAxisLabel, CategoryDataset data, PlotOrientation orientation, boolean legend, boolean tooltips, boolean urls, CategoryURLGenerator urlGenerator) {
        CategoryAxis3D categoryAxis = new CategoryAxis3D(categoryAxisLabel);
        NumberAxis3D valueAxis = new NumberAxis3D(valueAxisLabel);
        BarRenderer3D renderer = new BarRenderer3D();
        if (tooltips) {
            renderer.setToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        }
        if (urls) {
            renderer.setItemURLGenerator(urlGenerator);
        }
        CategoryPlot plot = new CategoryPlot(data, (CategoryAxis)categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(orientation);
        plot.setForegroundAlpha(0.75f);
        JFreeChart chart = new JFreeChart(title, titleFont, (Plot)plot, legend);
        return chart;
    }

    public static JFreeChart createStackedBarChart(String title, Font titleFont, String domainAxisLabel, String rangeAxisLabel, CategoryDataset data, PlotOrientation orientation, boolean legend, boolean tooltips, boolean urls, CategoryURLGenerator urlGenerator) {
        CategoryAxis categoryAxis = new CategoryAxis(domainAxisLabel);
        NumberAxis valueAxis = new NumberAxis(rangeAxisLabel);
        StackedBarRenderer renderer = new StackedBarRenderer();
        if (tooltips) {
            renderer.setToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        }
        if (urls) {
            renderer.setItemURLGenerator(urlGenerator);
        }
        CategoryPlot plot = new CategoryPlot(data, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(orientation);
        JFreeChart chart = new JFreeChart(title, titleFont, (Plot)plot, legend);
        return chart;
    }

    public static JFreeChart createStackedBarChart3D(String title, Font titleFont, String categoryAxisLabel, String valueAxisLabel, CategoryDataset data, PlotOrientation orientation, boolean legend, boolean tooltips, boolean urls, CategoryURLGenerator urlGenerator) {
        CategoryAxis3D categoryAxis = new CategoryAxis3D(categoryAxisLabel);
        NumberAxis3D valueAxis = new NumberAxis3D(valueAxisLabel);
        StackedBarRenderer3D renderer = new StackedBarRenderer3D();
        StandardCategoryToolTipGenerator toolTipGenerator = null;
        if (tooltips) {
            toolTipGenerator = new StandardCategoryToolTipGenerator();
        }
        if (urls) {
            renderer.setItemURLGenerator(urlGenerator);
        }
        renderer.setToolTipGenerator((CategoryToolTipGenerator)toolTipGenerator);
        CategoryPlot plot = new CategoryPlot(data, (CategoryAxis)categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(orientation);
        JFreeChart chart = new JFreeChart(title, titleFont, (Plot)plot, legend);
        return chart;
    }

    public static JFreeChart createLineChart(String title, Font titleFont, String categoryAxisLabel, String valueAxisLabel, CategoryDataset data, PlotOrientation orientation, boolean legend, boolean tooltips, boolean urls, CategoryURLGenerator urlGenerator) {
        CategoryAxis categoryAxis = new CategoryAxis(categoryAxisLabel);
        NumberAxis valueAxis = new NumberAxis(valueAxisLabel);
        LineAndShapeRenderer renderer = new LineAndShapeRenderer();
        renderer.setLinesVisible(true);
        renderer.setShapesVisible(false);
        if (tooltips) {
            renderer.setToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        }
        if (urls) {
            renderer.setItemURLGenerator(urlGenerator);
        }
        CategoryPlot plot = new CategoryPlot(data, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(orientation);
        JFreeChart chart = new JFreeChart(title, titleFont, (Plot)plot, legend);
        return chart;
    }

    public static JFreeChart createAreaChart(String title, Font titleFont, String categoryAxisLabel, String valueAxisLabel, CategoryDataset data, PlotOrientation orientation, boolean legend, boolean tooltips, boolean urls, CategoryURLGenerator urlGenerator) {
        CategoryAxis categoryAxis = new CategoryAxis(categoryAxisLabel);
        categoryAxis.setCategoryMargin(0.0);
        NumberAxis valueAxis = new NumberAxis(valueAxisLabel);
        AreaRenderer renderer = new AreaRenderer();
        if (tooltips) {
            renderer.setToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        }
        if (urls) {
            renderer.setItemURLGenerator(urlGenerator);
        }
        CategoryPlot plot = new CategoryPlot(data, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(orientation);
        JFreeChart chart = new JFreeChart(title, titleFont, (Plot)plot, legend);
        return chart;
    }

    public static JFreeChart createStackedAreaChart(String title, Font titleFont, String categoryAxisLabel, String valueAxisLabel, CategoryDataset data, PlotOrientation orientation, boolean legend, boolean tooltips, boolean urls, CategoryURLGenerator urlGenerator) {
        CategoryAxis categoryAxis = new CategoryAxis(categoryAxisLabel);
        NumberAxis valueAxis = new NumberAxis(valueAxisLabel);
        StackedAreaRenderer renderer = new StackedAreaRenderer();
        if (tooltips) {
            renderer.setToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        }
        if (urls) {
            renderer.setItemURLGenerator(urlGenerator);
        }
        CategoryPlot plot = new CategoryPlot(data, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(orientation);
        JFreeChart chart = new JFreeChart(title, titleFont, (Plot)plot, legend);
        return chart;
    }

    public static JFreeChart createTimeSeriesChart(String title, Font titleFont, String timeAxisLabel, String valueAxisLabel, XYDataset data, boolean legend, boolean tooltips, boolean urls) {
        DateAxis timeAxis = new DateAxis(timeAxisLabel);
        timeAxis.setLowerMargin(0.02);
        timeAxis.setUpperMargin(0.02);
        NumberAxis valueAxis = new NumberAxis(valueAxisLabel);
        valueAxis.setAutoRangeIncludesZero(false);
        XYPlot plot = new XYPlot(data, (ValueAxis)timeAxis, (ValueAxis)valueAxis, null);
        StandardXYToolTipGenerator tooltipGenerator = null;
        if (tooltips) {
            tooltipGenerator = StandardXYToolTipGenerator.getTimeSeriesInstance();
        }
        StandardXYURLGenerator urlGenerator = null;
        if (urls) {
            urlGenerator = new StandardXYURLGenerator();
        }
        plot.setRenderer((XYItemRenderer)new StandardXYItemRenderer(2, (XYToolTipGenerator)tooltipGenerator, (XYURLGenerator)urlGenerator));
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, legend);
        return chart;
    }
}

