/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.olap.query;

import com.tonbeller.jpivot.olap.model.BooleanExpr;
import com.tonbeller.jpivot.olap.model.Dimension;
import com.tonbeller.jpivot.olap.model.DoubleExpr;
import com.tonbeller.jpivot.olap.model.Expression;
import com.tonbeller.jpivot.olap.model.FunCallExpr;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.IntegerExpr;
import com.tonbeller.jpivot.olap.model.Level;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.ParameterExpr;
import com.tonbeller.jpivot.olap.model.StringExpr;
import com.tonbeller.jpivot.olap.model.VisitorSupportStrict;
import com.tonbeller.jpivot.olap.query.MDXElement;
import java.util.HashSet;
import java.util.Set;

public class ExprStringConverter
extends VisitorSupportStrict {
    static final Set infix = new HashSet();
    static final Set prefix = new HashSet();
    protected StringBuffer strbuf = null;

    public String exprToString(Expression e) {
        this.strbuf = new StringBuffer();
        e.accept(this);
        return this.strbuf.toString();
    }

    public void visitBooleanExpr(BooleanExpr v) {
        if (v.getValue()) {
            this.strbuf.append("true");
        } else {
            this.strbuf.append("false");
        }
    }

    public void visitDimension(Dimension v) {
        this.strbuf.append(((MDXElement)((Object)v)).getUniqueName());
    }

    public void visitDoubleExpr(DoubleExpr v) {
        this.strbuf.append(Double.toString(v.getValue()));
    }

    public void visitFunCallExpr(FunCallExpr v) {
        String name = v.getName();
        Expression[] args = v.getArgs();
        if (infix.contains(name) && args.length == 2) {
            args[0].accept(this);
            this.strbuf.append(' ');
            this.strbuf.append(name);
            this.strbuf.append(' ');
            args[1].accept(this);
            return;
        }
        if (v.getName().startsWith(".")) {
            name = name.substring(1);
            if (args.length == 1) {
                args[0].accept(this);
                this.strbuf.append('.');
                this.strbuf.append(name);
                return;
            }
        } else {
            if (prefix.contains(name)) {
                this.strbuf.append(name);
                this.strbuf.append(' ');
                args[0].accept(this);
                return;
            }
            if ("{}".equals(name)) {
                this.strbuf.append('{');
                for (int i = 0; i < args.length; ++i) {
                    if (i > 0) {
                        this.strbuf.append(',');
                    }
                    args[i].accept(this);
                }
                this.strbuf.append('}');
                return;
            }
            if ("()".equals(name)) {
                this.strbuf.append('(');
                for (int i = 0; i < args.length; ++i) {
                    if (i > 0) {
                        this.strbuf.append(',');
                    }
                    args[i].accept(this);
                }
                this.strbuf.append(')');
                return;
            }
        }
        this.strbuf.append(name);
        this.strbuf.append('(');
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                this.strbuf.append(',');
            }
            args[i].accept(this);
        }
        this.strbuf.append(')');
    }

    public void visitHierarchy(Hierarchy v) {
        this.strbuf.append(((MDXElement)((Object)v)).getUniqueName());
    }

    public void visitIntegerExpr(IntegerExpr v) {
        this.strbuf.append(Integer.toString(v.getValue()));
    }

    public void visitLevel(Level v) {
        this.strbuf.append(((MDXElement)((Object)v)).getUniqueName());
    }

    public void visitMember(Member v) {
        this.strbuf.append(((MDXElement)((Object)v)).getUniqueName());
    }

    public void visitParameterExpr(ParameterExpr v) {
        Expression val = v.getValue();
        ExprStringConverter strcnv = new ExprStringConverter();
        String valstr = strcnv.exprToString(val);
        this.strbuf.append(valstr);
    }

    public void visitStringExpr(StringExpr v) {
        this.strbuf.append(v.getValue());
    }

    static {
        String[] s = new String[]{"and", "or", "xor", "*", "/", "+", "-", "%", "<", ">", "<=", ">=", "<>", "="};
        for (int i = 0; i < s.length; ++i) {
            infix.add(s[i]);
        }
        prefix.add("-");
        prefix.add("not");
    }
}

