/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.intercept.web;

import java.util.Iterator;
import java.util.regex.PatternSyntaxException;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import junit.framework.TestCase;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.MockFilterChain;
import org.springframework.security.intercept.web.DefaultFilterInvocationDefinitionSource;
import org.springframework.security.intercept.web.FilterInvocation;
import org.springframework.security.intercept.web.FilterInvocationDefinitionSourceEditor;
import org.springframework.security.util.AntUrlPathMatcher;
import org.springframework.security.util.RegexUrlPathMatcher;

public class FilterInvocationDefinitionSourceEditorTests
extends TestCase {
    public FilterInvocationDefinitionSourceEditorTests() {
    }

    public FilterInvocationDefinitionSourceEditorTests(String arg0) {
        super(arg0);
    }

    public void testConvertUrlToLowercaseDefaultSettingUnchangedByEditor() {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        editor.setAsText("\\A/secure/super.*\\Z=ROLE_WE_DONT_HAVE\r\n\\A/secure/.*\\Z=ROLE_SUPERVISOR,ROLE_TELLER");
        DefaultFilterInvocationDefinitionSource map = (DefaultFilterInvocationDefinitionSource)editor.getValue();
        FilterInvocationDefinitionSourceEditorTests.assertFalse((boolean)map.isConvertUrlToLowercaseBeforeComparison());
    }

    public void testConvertUrlToLowercaseDetectsUppercaseEntries() {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        try {
            editor.setAsText("CONVERT_URL_TO_LOWERCASE_BEFORE_COMPARISON\r\nPATTERN_TYPE_APACHE_ANT\r\n\\/secUre/super/**=ROLE_WE_DONT_HAVE");
            FilterInvocationDefinitionSourceEditorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            FilterInvocationDefinitionSourceEditorTests.assertTrue((expected.getMessage().lastIndexOf("you have specified an uppercase character in line") != -1 ? 1 : 0) != 0);
        }
    }

    public void testConvertUrlToLowercaseSettingApplied() {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        editor.setAsText("CONVERT_URL_TO_LOWERCASE_BEFORE_COMPARISON\r\n\\A/secure/super.*\\Z=ROLE_WE_DONT_HAVE\r\n\\A/secure/.*\\Z=ROLE_SUPERVISOR,ROLE_TELLER");
        DefaultFilterInvocationDefinitionSource map = (DefaultFilterInvocationDefinitionSource)editor.getValue();
        FilterInvocationDefinitionSourceEditorTests.assertTrue((boolean)map.isConvertUrlToLowercaseBeforeComparison());
    }

    public void testDefaultIsRegularExpression() {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        editor.setAsText("\\A/secure/super.*\\Z=ROLE_WE_DONT_HAVE\r\n\\A/secure/.*\\Z=ROLE_SUPERVISOR,ROLE_TELLER");
        DefaultFilterInvocationDefinitionSource map = (DefaultFilterInvocationDefinitionSource)editor.getValue();
        FilterInvocationDefinitionSourceEditorTests.assertTrue((boolean)(map.getUrlMatcher() instanceof RegexUrlPathMatcher));
    }

    public void testDetectsDuplicateDirectivesOnSameLineSituation1() {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        try {
            editor.setAsText("CONVERT_URL_TO_LOWERCASE_BEFORE_COMPARISON PATTERN_TYPE_APACHE_ANT\r\n\\/secure/super/**=ROLE_WE_DONT_HAVE");
            FilterInvocationDefinitionSourceEditorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            FilterInvocationDefinitionSourceEditorTests.assertTrue((expected.getMessage().lastIndexOf("Line appears to be malformed") != -1 ? 1 : 0) != 0);
        }
    }

    public void testDetectsDuplicateDirectivesOnSameLineSituation2() {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        try {
            editor.setAsText("CONVERT_URL_TO_LOWERCASE_BEFORE_COMPARISON\r\nPATTERN_TYPE_APACHE_ANT /secure/super/**=ROLE_WE_DONT_HAVE");
            FilterInvocationDefinitionSourceEditorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            FilterInvocationDefinitionSourceEditorTests.assertTrue((expected.getMessage().lastIndexOf("Line appears to be malformed") != -1 ? 1 : 0) != 0);
        }
    }

    public void testDetectsDuplicateDirectivesOnSameLineSituation3() {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        try {
            editor.setAsText("PATTERN_TYPE_APACHE_ANT\r\nCONVERT_URL_TO_LOWERCASE_BEFORE_COMPARISON /secure/super/**=ROLE_WE_DONT_HAVE");
            FilterInvocationDefinitionSourceEditorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            FilterInvocationDefinitionSourceEditorTests.assertTrue((expected.getMessage().lastIndexOf("Line appears to be malformed") != -1 ? 1 : 0) != 0);
        }
    }

    public void testEmptyStringReturnsEmptyMap() {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        editor.setAsText("");
        DefaultFilterInvocationDefinitionSource map = (DefaultFilterInvocationDefinitionSource)editor.getValue();
        FilterInvocationDefinitionSourceEditorTests.assertEquals((int)0, (int)map.getMapSize());
    }

    public void testInvalidRegularExpressionsDetected() throws Exception {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        try {
            editor.setAsText("*=SOME_ROLE");
            FilterInvocationDefinitionSourceEditorTests.fail((String)"Expected PatternSyntaxException");
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
    }

    public void testIterator() {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        editor.setAsText("\\A/secure/super.*\\Z=ROLE_WE_DONT_HAVE\r\n\\A/secure/.*\\Z=ROLE_SUPERVISOR,ROLE_TELLER");
        DefaultFilterInvocationDefinitionSource map = (DefaultFilterInvocationDefinitionSource)editor.getValue();
        Iterator iter = map.getConfigAttributeDefinitions().iterator();
        int counter = 0;
        while (iter.hasNext()) {
            iter.next();
            ++counter;
        }
        FilterInvocationDefinitionSourceEditorTests.assertEquals((int)2, (int)counter);
    }

    public void testMapReturnsNullWhenNoMatchFound() throws Exception {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        editor.setAsText("\\A/secure/super.*\\Z=ROLE_WE_DONT_HAVE,ANOTHER_ROLE");
        DefaultFilterInvocationDefinitionSource map = (DefaultFilterInvocationDefinitionSource)editor.getValue();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest(null, null);
        httpRequest.setServletPath("/totally/different/path/index.html");
        ConfigAttributeDefinition returned = map.getAttributes((Object)new FilterInvocation((ServletRequest)httpRequest, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain()));
        FilterInvocationDefinitionSourceEditorTests.assertEquals(null, (Object)returned);
    }

    public void testMultiUrlParsing() {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        editor.setAsText("\\A/secure/super.*\\Z=ROLE_WE_DONT_HAVE\r\n\\A/secure/.*\\Z=ROLE_SUPERVISOR,ROLE_TELLER");
        DefaultFilterInvocationDefinitionSource map = (DefaultFilterInvocationDefinitionSource)editor.getValue();
        FilterInvocationDefinitionSourceEditorTests.assertEquals((int)2, (int)map.getMapSize());
    }

    public void testNullReturnsEmptyMap() {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        editor.setAsText(null);
        DefaultFilterInvocationDefinitionSource map = (DefaultFilterInvocationDefinitionSource)editor.getValue();
        FilterInvocationDefinitionSourceEditorTests.assertEquals((int)0, (int)map.getMapSize());
    }

    public void testOrderOfEntriesIsPreservedOrderA() {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        editor.setAsText("\\A/secure/super.*\\Z=ROLE_WE_DONT_HAVE,ANOTHER_ROLE\r\n\\A/secure/.*\\Z=ROLE_SUPERVISOR,ROLE_TELLER");
        DefaultFilterInvocationDefinitionSource map = (DefaultFilterInvocationDefinitionSource)editor.getValue();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest(null, null);
        httpRequest.setServletPath("/secure/super/very_secret.html");
        ConfigAttributeDefinition returned = map.getAttributes((Object)new FilterInvocation((ServletRequest)httpRequest, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain()));
        ConfigAttributeDefinition expected = new ConfigAttributeDefinition(new String[]{"ROLE_WE_DONT_HAVE", "ANOTHER_ROLE"});
        FilterInvocationDefinitionSourceEditorTests.assertEquals((Object)expected, (Object)returned);
    }

    public void testOrderOfEntriesIsPreservedOrderB() {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        editor.setAsText("\\A/secure/.*\\Z=ROLE_SUPERVISOR,ROLE_TELLER\r\n\\A/secure/super.*\\Z=ROLE_WE_DONT_HAVE,ANOTHER_ROLE");
        DefaultFilterInvocationDefinitionSource map = (DefaultFilterInvocationDefinitionSource)editor.getValue();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest(null, null);
        httpRequest.setServletPath("/secure/super/very_secret.html");
        ConfigAttributeDefinition returned = map.getAttributes((Object)new FilterInvocation((ServletRequest)httpRequest, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain()));
        ConfigAttributeDefinition expected = new ConfigAttributeDefinition(new String[]{"ROLE_SUPERVISOR", "ROLE_TELLER"});
        FilterInvocationDefinitionSourceEditorTests.assertEquals((Object)expected, (Object)returned);
    }

    public void testSingleUrlParsingWithRegularExpressions() throws Exception {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        editor.setAsText("\\A/secure/super.*\\Z=ROLE_WE_DONT_HAVE,ANOTHER_ROLE");
        DefaultFilterInvocationDefinitionSource map = (DefaultFilterInvocationDefinitionSource)editor.getValue();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest(null, null);
        httpRequest.setServletPath("/secure/super/very_secret.html");
        ConfigAttributeDefinition returned = map.getAttributes((Object)new FilterInvocation((ServletRequest)httpRequest, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain()));
        ConfigAttributeDefinition expected = new ConfigAttributeDefinition(new String[]{"ROLE_WE_DONT_HAVE", "ANOTHER_ROLE"});
        FilterInvocationDefinitionSourceEditorTests.assertEquals((Object)expected, (Object)returned);
    }

    public void testSingleUrlParsingWithAntPaths() throws Exception {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        editor.setAsText("PATTERN_TYPE_APACHE_ANT\r\n/secure/super/**=ROLE_WE_DONT_HAVE,ANOTHER_ROLE");
        DefaultFilterInvocationDefinitionSource map = (DefaultFilterInvocationDefinitionSource)editor.getValue();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest(null, null);
        httpRequest.setServletPath("/secure/super/very_secret.html");
        ConfigAttributeDefinition returned = map.getAttributes((Object)new FilterInvocation((ServletRequest)httpRequest, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain()));
        ConfigAttributeDefinition expected = new ConfigAttributeDefinition(new String[]{"ROLE_WE_DONT_HAVE", "ANOTHER_ROLE"});
        FilterInvocationDefinitionSourceEditorTests.assertEquals((Object)expected, (Object)returned);
    }

    public void testWhitespaceAndCommentsAndLinesWithoutEqualsSignsAreIgnored() {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        editor.setAsText("         \\A/secure/super.*\\Z=ROLE_WE_DONT_HAVE,ANOTHER_ROLE      \r\n   \r\n     \r\n   // comment line  \r\n   \\A/testing.*\\Z=ROLE_TEST   \r\n");
        DefaultFilterInvocationDefinitionSource map = (DefaultFilterInvocationDefinitionSource)editor.getValue();
        FilterInvocationDefinitionSourceEditorTests.assertEquals((int)2, (int)map.getMapSize());
    }

    public void testAntPathDirectiveIsDetected() {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        editor.setAsText("PATTERN_TYPE_APACHE_ANT\r\n/secure/super/*=ROLE_WE_DONT_HAVE\r\n/secure/*=ROLE_SUPERVISOR,ROLE_TELLER");
        DefaultFilterInvocationDefinitionSource map = (DefaultFilterInvocationDefinitionSource)editor.getValue();
        FilterInvocationDefinitionSourceEditorTests.assertTrue((boolean)(map.getUrlMatcher() instanceof AntUrlPathMatcher));
    }

    public void testInvalidNameValueFailsToParse() {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        try {
            editor.setAsText("         PATTERN_TYPE_APACHE_ANT\r\n    /secure/*==ROLE_SUPERVISOR,ROLE_TELLER      \r\n");
            FilterInvocationDefinitionSourceEditorTests.fail((String)"Shouldn't be able to use '==' for config attribute.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSingleUrlParsing() throws Exception {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        editor.setAsText("PATTERN_TYPE_APACHE_ANT\r\n/secure/super/*=ROLE_WE_DONT_HAVE,ANOTHER_ROLE");
        DefaultFilterInvocationDefinitionSource map = (DefaultFilterInvocationDefinitionSource)editor.getValue();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest(null, null);
        httpRequest.setServletPath("/secure/super/very_secret.html");
        ConfigAttributeDefinition returned = map.getAttributes((Object)new FilterInvocation((ServletRequest)httpRequest, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain()));
        ConfigAttributeDefinition expected = new ConfigAttributeDefinition(new String[]{"ROLE_WE_DONT_HAVE", "ANOTHER_ROLE"});
        FilterInvocationDefinitionSourceEditorTests.assertEquals((Object)expected, (Object)returned);
    }
}

