/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap;

import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.jmock.Mock;
import org.jmock.MockObjectTestCase;
import org.springframework.security.ldap.LdapUtils;

public class LdapUtilsTests
extends MockObjectTestCase {
    public void testCloseContextSwallowsNamingException() {
        Mock mockCtx = this.mock(DirContext.class);
        mockCtx.expects(this.once()).method("close").will(this.throwException(new NamingException()));
        LdapUtils.closeContext((Context)((Context)mockCtx.proxy()));
    }

    public void testGetRelativeNameReturnsEmptyStringForDnEqualToBaseName() throws Exception {
        Mock mockCtx = this.mock(DirContext.class);
        mockCtx.expects(this.atLeastOnce()).method("getNameInNamespace").will(this.returnValue("dc=springframework,dc=org"));
        LdapUtilsTests.assertEquals((String)"", (String)LdapUtils.getRelativeName((String)"dc=springframework,dc=org", (Context)((Context)mockCtx.proxy())));
    }

    public void testGetRelativeNameReturnsFullDnWithEmptyBaseName() throws Exception {
        Mock mockCtx = this.mock(DirContext.class);
        mockCtx.expects(this.atLeastOnce()).method("getNameInNamespace").will(this.returnValue(""));
        LdapUtilsTests.assertEquals((String)"cn=jane,dc=springframework,dc=org", (String)LdapUtils.getRelativeName((String)"cn=jane,dc=springframework,dc=org", (Context)((Context)mockCtx.proxy())));
    }

    public void testGetRelativeNameWorksWithArbitrarySpaces() throws Exception {
        Mock mockCtx = this.mock(DirContext.class);
        mockCtx.expects(this.atLeastOnce()).method("getNameInNamespace").will(this.returnValue("dc=springsecurity,dc = org"));
        LdapUtilsTests.assertEquals((String)"cn=jane smith", (String)LdapUtils.getRelativeName((String)"cn=jane smith, dc = springsecurity , dc=org", (Context)((Context)mockCtx.proxy())));
    }

    public void testRootDnsAreParsedFromUrlsCorrectly() {
        LdapUtilsTests.assertEquals((String)"", (String)LdapUtils.parseRootDnFromUrl((String)"ldap://monkeymachine"));
        LdapUtilsTests.assertEquals((String)"", (String)LdapUtils.parseRootDnFromUrl((String)"ldap://monkeymachine:11389"));
        LdapUtilsTests.assertEquals((String)"", (String)LdapUtils.parseRootDnFromUrl((String)"ldap://monkeymachine/"));
        LdapUtilsTests.assertEquals((String)"", (String)LdapUtils.parseRootDnFromUrl((String)"ldap://monkeymachine.co.uk/"));
        LdapUtilsTests.assertEquals((String)"dc=springframework,dc=org", (String)LdapUtils.parseRootDnFromUrl((String)"ldaps://monkeymachine.co.uk/dc=springframework,dc=org"));
        LdapUtilsTests.assertEquals((String)"dc=springframework,dc=org", (String)LdapUtils.parseRootDnFromUrl((String)"ldap:///dc=springframework,dc=org"));
        LdapUtilsTests.assertEquals((String)"dc=springframework,dc=org", (String)LdapUtils.parseRootDnFromUrl((String)"ldap://monkeymachine/dc=springframework,dc=org"));
        LdapUtilsTests.assertEquals((String)"dc=springframework,dc=org/ou=blah", (String)LdapUtils.parseRootDnFromUrl((String)"ldap://monkeymachine.co.uk/dc=springframework,dc=org/ou=blah"));
        LdapUtilsTests.assertEquals((String)"dc=springframework,dc=org/ou=blah", (String)LdapUtils.parseRootDnFromUrl((String)"ldap://monkeymachine.co.uk:389/dc=springframework,dc=org/ou=blah"));
    }
}

