/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.wrapper;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.MockFilterConfig;
import org.springframework.security.wrapper.SavedRequestAwareWrapper;
import org.springframework.security.wrapper.SecurityContextHolderAwareRequestFilter;

public class SecurityContextHolderAwareRequestFilterTests
extends TestCase {
    public SecurityContextHolderAwareRequestFilterTests() {
    }

    public SecurityContextHolderAwareRequestFilterTests(String arg0) {
        super(arg0);
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testCorrectOperation() throws Exception {
        SecurityContextHolderAwareRequestFilter filter = new SecurityContextHolderAwareRequestFilter();
        filter.init((FilterConfig)new MockFilterConfig());
        filter.doFilter((ServletRequest)new MockHttpServletRequest(null, null), (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain(SavedRequestAwareWrapper.class));
        filter.doFilter((ServletRequest)new MockHttpServletRequest(null, null), (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain(SavedRequestAwareWrapper.class));
        filter.destroy();
    }

    private class MockFilterChain
    implements FilterChain {
        private Class expectedServletRequest;

        public MockFilterChain(Class expectedServletRequest) {
            this.expectedServletRequest = expectedServletRequest;
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (request.getClass().isAssignableFrom(this.expectedServletRequest)) {
                Assert.assertTrue((boolean)true);
            } else {
                Assert.fail((String)("Expected class to be of type " + this.expectedServletRequest + " but was: " + request.getClass()));
            }
        }
    }
}

