/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire;

import org.apache.maven.plugin.surefire.CommonReflector;
import org.apache.maven.plugin.surefire.StartupReportConfiguration;
import org.apache.maven.surefire.booter.ProviderConfiguration;
import org.apache.maven.surefire.booter.ProviderFactory;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.SurefireExecutionException;
import org.apache.maven.surefire.suite.RunResult;

public class InPluginVMSurefireStarter {
    private final StartupConfiguration startupConfiguration;
    private final StartupReportConfiguration startupReportConfiguration;
    private final ProviderConfiguration providerConfiguration;

    public InPluginVMSurefireStarter(StartupConfiguration startupConfiguration, ProviderConfiguration providerConfiguration, StartupReportConfiguration startupReportConfiguration) {
        this.startupConfiguration = startupConfiguration;
        this.startupReportConfiguration = startupReportConfiguration;
        this.providerConfiguration = providerConfiguration;
    }

    public RunResult runSuitesInProcess() throws SurefireExecutionException {
        this.startupConfiguration.writeSurefireTestClasspathProperty();
        ClassLoader testsClassLoader = this.startupConfiguration.getClasspathConfiguration().createTestClassLoader();
        ClassLoader surefireClassLoader = this.startupConfiguration.getClasspathConfiguration().createInprocSurefireClassLoader(testsClassLoader);
        CommonReflector surefireReflector = new CommonReflector(surefireClassLoader);
        Object factory = surefireReflector.createReportingReporterFactory(this.startupReportConfiguration);
        return ProviderFactory.invokeProvider(null, (ClassLoader)testsClassLoader, (ClassLoader)surefireClassLoader, (Object)factory, (ProviderConfiguration)this.providerConfiguration, (boolean)false, (StartupConfiguration)this.startupConfiguration);
    }
}

