/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.security.Principal;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.security.auth.Subject;
import org.teiid.CommandContext;
import org.teiid.adminapi.Session;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.dqp.internal.process.RequestWorkItem;
import org.teiid.dqp.message.RequestID;
import org.teiid.translator.CacheDirective;
import org.teiid.translator.ExecutionContext;

public class ExecutionContextImpl
implements ExecutionContext {
    private String partID;
    private String connectorName;
    private String executeCount;
    private boolean keepAlive = false;
    private boolean isTransactional;
    private int batchSize = 512;
    private List<Exception> warnings = new LinkedList<Exception>();
    private Session session;
    private WeakReference<RequestWorkItem> worktItem;
    private boolean dataAvailable;
    private String generalHint;
    private String hint;
    private org.teiid.query.util.CommandContext commandContext;
    private CacheDirective cacheDirective;

    public ExecutionContextImpl(String vdbName, int vdbVersion, Serializable executionPayload, String originalConnectionID, String connectorName, long requestId, String partId, String execCount) {
        this.commandContext = new org.teiid.query.util.CommandContext();
        this.commandContext.setVdbName(vdbName);
        this.commandContext.setVdbVersion(vdbVersion);
        this.commandContext.setCommandPayload(executionPayload);
        this.commandContext.setConnectionID(originalConnectionID);
        this.commandContext.setRequestId(new RequestID(originalConnectionID, requestId));
        this.connectorName = connectorName;
        this.partID = partId;
        this.executeCount = execCount;
    }

    public ExecutionContextImpl(org.teiid.query.util.CommandContext commandContext, String connectorName, String partId, String execCount) {
        this.connectorName = connectorName;
        this.partID = partId;
        this.executeCount = execCount;
        this.commandContext = commandContext;
    }

    public CommandContext getCommandContext() {
        return this.commandContext;
    }

    public String getConnectorIdentifier() {
        return this.connectorName;
    }

    public String getRequestId() {
        return this.commandContext.getRequestId();
    }

    public String getPartIdentifier() {
        return this.partID;
    }

    public String getExecutionCountIdentifier() {
        return this.executeCount;
    }

    public String getVdbName() {
        return this.commandContext.getVdbName();
    }

    public int getVdbVersion() {
        return this.commandContext.getVdbVersion();
    }

    public Subject getSubject() {
        return this.commandContext.getSubject();
    }

    public Serializable getCommandPayload() {
        return this.commandContext.getCommandPayload();
    }

    public String getConnectionId() {
        return this.commandContext.getConnectionId();
    }

    public void keepExecutionAlive(boolean alive) {
        this.keepAlive = alive;
    }

    boolean keepExecutionAlive() {
        return this.keepAlive;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ExecutionContext)) {
            return false;
        }
        ExecutionContext other = (ExecutionContext)obj;
        return EquivalenceUtil.areEqual((Object)this.getRequestId(), (Object)other.getRequestId()) && EquivalenceUtil.areEqual((Object)this.getPartIdentifier(), (Object)other.getPartIdentifier());
    }

    public int hashCode() {
        return HashCodeUtil.hashCode((int)HashCodeUtil.hashCode((int)0, (Object[])new Object[]{this.getRequestId()}), (Object[])new Object[]{this.partID});
    }

    public String toString() {
        String userName = null;
        if (this.getSubject() != null) {
            for (Principal p : this.getSubject().getPrincipals()) {
                userName = p.getName();
            }
        }
        return "ExecutionContext<vdb=" + this.getVdbName() + ", version=" + this.getVdbVersion() + ", user=" + userName + ">";
    }

    public boolean isTransactional() {
        return this.isTransactional;
    }

    void setTransactional(boolean isTransactional) {
        this.isTransactional = isTransactional;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void addWarning(Exception ex) {
        if (ex == null) {
            return;
        }
        this.warnings.add(ex);
    }

    public List<Exception> getWarnings() {
        ArrayList<Exception> result = new ArrayList<Exception>(this.warnings);
        this.warnings.clear();
        return result;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public void setRequestWorkItem(RequestWorkItem item) {
        this.worktItem = new WeakReference<RequestWorkItem>(item);
    }

    public synchronized void dataAvailable() {
        RequestWorkItem requestWorkItem = (RequestWorkItem)this.worktItem.get();
        this.dataAvailable = true;
        if (requestWorkItem != null) {
            requestWorkItem.moreWork();
        }
    }

    public synchronized boolean isDataAvailable() {
        boolean result = this.dataAvailable;
        this.dataAvailable = false;
        return result;
    }

    public String getGeneralHint() {
        return this.generalHint;
    }

    public String getSourceHint() {
        return this.hint;
    }

    public void setGeneralHint(String generalHint) {
        this.generalHint = generalHint;
    }

    public void setHint(String hint) {
        this.hint = hint;
    }

    public String getConnectionID() {
        return this.getConnectionId();
    }

    public Serializable getExecutionPayload() {
        return this.getCommandPayload();
    }

    public String getRequestID() {
        return this.getRequestId();
    }

    public String getVirtualDatabaseName() {
        return this.getVdbName();
    }

    public int getVirtualDatabaseVersion() {
        return this.getVdbVersion();
    }

    public CacheDirective getCacheDirective() {
        return this.cacheDirective;
    }

    public void setCacheDirective(CacheDirective directive) {
        this.cacheDirective = directive;
    }
}

