/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.xml;

import java.util.LinkedList;
import java.util.Map;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.mapping.xml.MappingAttribute;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.MappingElement;
import org.teiid.query.mapping.xml.MappingSourceNode;
import org.teiid.query.mapping.xml.MappingVisitor;
import org.teiid.query.mapping.xml.Navigator;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.optimizer.xml.QueryUtil;
import org.teiid.query.optimizer.xml.XMLPlannerEnvironment;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;

public class NameInSourceResolverVisitor
extends MappingVisitor {
    XMLPlannerEnvironment planEnv;

    NameInSourceResolverVisitor(XMLPlannerEnvironment planEnv) {
        this.planEnv = planEnv;
    }

    @Override
    public void visit(MappingSourceNode element) {
        if (element.getAliasResultName() == null) {
            return;
        }
        Map symbols = element.getSymbolMap();
        LinkedList<ElementSymbol> elements = new LinkedList<ElementSymbol>();
        for (Object symbol : symbols.values()) {
            if (!(symbol instanceof ElementSymbol)) continue;
            elements.add((ElementSymbol)symbol);
        }
        Map fixedMap = QueryUtil.createSymbolMap(new GroupSymbol(element.getActualResultSetName()), element.getAliasResultName(), elements);
        NameInSourceResolverVisitor.updateSymbolMap(element, fixedMap);
        symbols.putAll(fixedMap);
    }

    @Override
    public void visit(MappingAttribute attribute) {
        String nameInSource = attribute.getNameInSource();
        if (nameInSource != null) {
            MappingSourceNode sourceNode = attribute.getSourceNode();
            ElementSymbol symbol = this.resolveElementSymbol(nameInSource, sourceNode);
            attribute.setElementSymbol(symbol);
        }
    }

    @Override
    public void visit(MappingElement element) {
        String nameInSource = element.getNameInSource();
        if (nameInSource != null) {
            MappingSourceNode sourceNode = element.getSourceNode();
            ElementSymbol symbol = this.resolveElementSymbol(nameInSource, sourceNode);
            element.setElementSymbol(symbol);
        }
    }

    private ElementSymbol resolveElementSymbol(String elementName, MappingSourceNode sourceNode) {
        try {
            TempMetadataAdapter metadata = this.planEnv.getGlobalMetadata();
            ElementSymbol symbol = sourceNode.getMappedSymbol(new ElementSymbol(elementName));
            Object elementID = metadata.getElementID(symbol.getName());
            symbol.setMetadataID(elementID);
            Object groupID = metadata.getGroupIDForElementID(elementID);
            String groupName = metadata.getFullName(groupID);
            GroupSymbol groupSymbol = new GroupSymbol(groupName);
            groupSymbol.setMetadataID(groupID);
            symbol.setGroupSymbol(groupSymbol);
            symbol.setType(DataTypeManager.getDataTypeClass((String)metadata.getElementType(symbol.getMetadataID())));
            return symbol;
        }
        catch (QueryMetadataException e) {
            throw new TeiidRuntimeException((Throwable)((Object)e));
        }
        catch (TeiidComponentException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    public static void resolveElements(MappingDocument doc, XMLPlannerEnvironment planEnv) throws QueryMetadataException, TeiidComponentException {
        NameInSourceResolverVisitor real = new NameInSourceResolverVisitor(planEnv);
        try {
            Navigator visitor = new Navigator(true, real);
            doc.acceptVisitor(visitor);
        }
        catch (TeiidRuntimeException e) {
            if (e.getCause() instanceof QueryMetadataException) {
                throw (QueryMetadataException)((Object)e.getCause());
            }
            if (e.getCause() instanceof TeiidComponentException) {
                throw (TeiidComponentException)e.getCause();
            }
            throw e;
        }
    }

    static void updateSymbolMap(MappingSourceNode source, Map target) {
        for (Map.Entry entry : source.getSymbolMap().entrySet()) {
            Object newValue = target.get(entry.getValue());
            if (newValue == null) continue;
            entry.setValue(newValue);
        }
        source.updateSymbolMapDependentValues();
    }
}

