/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.List;
import org.teiid.common.buffer.BufferManager;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.processor.relational.JoinNode;
import org.teiid.query.processor.relational.SourceState;

public abstract class JoinStrategy {
    protected JoinNode joinNode;
    protected SourceState leftSource;
    protected SourceState rightSource;
    private int reserved;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.joinNode == null) {
            return;
        }
        this.joinNode.getBufferManager().releaseBuffers(this.reserved);
        this.reserved = 0;
        try {
            if (this.leftSource != null) {
                this.leftSource.close();
            }
        }
        finally {
            try {
                if (this.rightSource != null) {
                    this.rightSource.close();
                }
            }
            finally {
                this.leftSource = null;
                this.rightSource = null;
            }
        }
    }

    public void initialize(JoinNode joinNode) {
        this.joinNode = joinNode;
        this.leftSource = new SourceState(joinNode.getChildren()[0], joinNode.getLeftExpressions());
        this.leftSource.markDistinct(this.joinNode.isLeftDistinct());
        this.rightSource = new SourceState(joinNode.getChildren()[1], joinNode.getRightExpressions());
        this.rightSource.markDistinct(this.joinNode.isRightDistinct());
    }

    protected void loadLeft() throws TeiidComponentException, TeiidProcessingException {
    }

    protected void loadRight() throws TeiidComponentException, TeiidProcessingException {
    }

    protected List outputTuple(List leftTuple, List rightTuple) {
        ArrayList combinedRow = new ArrayList(this.joinNode.getCombinedElementMap().size());
        combinedRow.addAll(leftTuple);
        combinedRow.addAll(rightTuple);
        return combinedRow;
    }

    protected abstract void process() throws TeiidComponentException, TeiidProcessingException;

    public abstract JoinStrategy clone();

    protected void openLeft() throws TeiidComponentException, TeiidProcessingException {
        if (!this.leftSource.open) {
            this.leftSource.getSource().open();
            this.leftSource.open = true;
        }
    }

    protected void openRight() throws TeiidComponentException, TeiidProcessingException {
        if (!this.rightSource.open) {
            if (this.reserved == 0) {
                this.reserved = this.joinNode.getBufferManager().reserveBuffers(this.joinNode.getBufferManager().getSchemaSize(this.joinNode.getOutputElements()), BufferManager.BufferReserveMode.FORCE);
            }
            this.rightSource.getSource().open();
            this.rightSource.open = true;
        }
    }
}

