/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.QueryProcessor;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.SourceHint;
import org.teiid.query.sql.lang.WithQueryCommand;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.tempdata.TempTableStore;
import org.teiid.query.util.CommandContext;

public class RelationalPlan
extends ProcessorPlan {
    private RelationalNode root;
    private List<? extends Expression> outputCols;
    private List<WithQueryCommand> with;
    private TempTableStore tempTableStore;
    private boolean multisourceUpdate;
    private SourceHint sourceHint;

    public RelationalPlan(RelationalNode node) {
        this.root = node;
    }

    public RelationalNode getRootNode() {
        return this.root;
    }

    public void setRootNode(RelationalNode root) {
        this.root = root;
    }

    public void setWith(List<WithQueryCommand> with) {
        this.with = with;
    }

    public void setSourceHint(SourceHint sourceHint) {
        this.sourceHint = sourceHint;
    }

    public SourceHint getSourceHint() {
        return this.sourceHint;
    }

    @Override
    public void initialize(CommandContext context, ProcessorDataManager dataMgr, BufferManager bufferMgr) {
        if (this.sourceHint != null && context.getSourceHint() == null) {
            context.setSourceHint(this.sourceHint);
        }
        if (this.with != null) {
            context = context.clone();
            this.tempTableStore = new TempTableStore(context.getConnectionId(), TempTableStore.TransactionMode.NONE);
            this.tempTableStore.setParentTempTableStore(context.getTempTableStore());
            context.setTempTableStore(this.tempTableStore);
        }
        this.setContext(context);
        this.connectExternal(this.root, context, dataMgr, bufferMgr);
    }

    private void connectExternal(RelationalNode node, CommandContext context, ProcessorDataManager dataMgr, BufferManager bufferMgr) {
        node.initialize(context, bufferMgr, dataMgr);
        RelationalNode[] children = node.getChildren();
        for (int i = 0; i < children.length && children[i] != null; ++i) {
            this.connectExternal(children[i], context, dataMgr, bufferMgr);
        }
    }

    @Override
    public List<? extends Expression> getOutputElements() {
        return this.outputCols;
    }

    @Override
    public void open() throws TeiidComponentException, TeiidProcessingException {
        if (this.with != null) {
            HashMap<String, TempTableStore.TableProcessor> processors = new HashMap<String, TempTableStore.TableProcessor>();
            this.tempTableStore.setProcessors(processors);
            for (WithQueryCommand withCommand : this.with) {
                ProcessorPlan plan = withCommand.getCommand().getProcessorPlan();
                QueryProcessor withProcessor = new QueryProcessor(plan, this.getContext(), this.root.getBufferManager(), this.root.getDataManager());
                processors.put(withCommand.getGroupSymbol().getName(), new TempTableStore.TableProcessor(withProcessor, withCommand.getColumns()));
            }
        }
        this.root.open();
    }

    @Override
    public TupleBatch nextBatch() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        return this.root.nextBatch();
    }

    @Override
    public void close() throws TeiidComponentException {
        if (this.tempTableStore != null) {
            this.tempTableStore.removeTempTables();
            if (this.tempTableStore.getProcessors() != null) {
                for (TempTableStore.TableProcessor proc : this.tempTableStore.getProcessors().values()) {
                    proc.getQueryProcessor().closeProcessing();
                }
                this.tempTableStore.setProcessors(null);
            }
        }
        this.root.close();
    }

    @Override
    public void reset() {
        super.reset();
        this.root.reset();
        if (this.with != null) {
            for (WithQueryCommand withCommand : this.with) {
                withCommand.getCommand().getProcessorPlan().reset();
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.with != null) {
            sb.append("WITH");
            for (WithQueryCommand withCommand : this.with) {
                sb.append("\n");
                sb.append(withCommand.getCommand().getProcessorPlan());
            }
        }
        sb.append(this.root.toString());
        return sb.toString();
    }

    @Override
    public RelationalPlan clone() {
        RelationalPlan plan = new RelationalPlan((RelationalNode)this.root.clone());
        plan.sourceHint = this.sourceHint;
        plan.setOutputElements(this.outputCols);
        if (this.with != null) {
            ArrayList<WithQueryCommand> newWith = LanguageObject.Util.deepClone(this.with, WithQueryCommand.class);
            for (WithQueryCommand withQueryCommand : newWith) {
                withQueryCommand.getCommand().setProcessorPlan(withQueryCommand.getCommand().getProcessorPlan().clone());
            }
            plan.setWith(newWith);
        }
        return plan;
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode node = this.root.getDescriptionProperties();
        if (this.with != null) {
            AnalysisRecord.addLanaguageObjects(node, "With", this.with);
        }
        return node;
    }

    public void setOutputElements(List<? extends Expression> outputCols) {
        this.outputCols = outputCols;
    }

    public void setMultisourceUpdate(boolean multisourceUpdate) {
        this.multisourceUpdate = multisourceUpdate;
    }

    @Override
    public boolean requiresTransaction(boolean transactionalReads) {
        if (this.multisourceUpdate) {
            return true;
        }
        if (this.with != null) {
            if (transactionalReads) {
                return true;
            }
            for (WithQueryCommand withCommand : this.with) {
                if (!withCommand.getCommand().getProcessorPlan().requiresTransaction(transactionalReads)) continue;
                return true;
            }
        }
        return Boolean.TRUE.equals(RelationalPlan.requiresTransaction(transactionalReads, this.root));
    }

    static Boolean requiresTransaction(boolean transactionalReads, RelationalNode node) {
        Boolean requiresTxn = node.requiresTransaction(transactionalReads);
        if (Boolean.TRUE.equals(requiresTxn)) {
            return true;
        }
        for (RelationalNode child : node.getChildren()) {
            if (child == null) continue;
            Boolean childRequires = RelationalPlan.requiresTransaction(transactionalReads, child);
            if (Boolean.TRUE.equals(childRequires)) {
                return true;
            }
            if (!transactionalReads || childRequires != null) continue;
            if (requiresTxn == null) {
                return true;
            }
            requiresTxn = null;
        }
        return requiresTxn;
    }

    @Override
    public TupleBuffer getFinalBuffer(int maxRows) throws BlockedException, TeiidComponentException, TeiidProcessingException {
        return this.root.getFinalBuffer(maxRows);
    }

    @Override
    public boolean hasFinalBuffer() {
        return this.root.hasFinalBuffer();
    }
}

