/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.xml;

import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.mapping.xml.ResultSetInfo;
import org.teiid.query.processor.xml.ExecSqlInstruction;
import org.teiid.query.processor.xml.XMLContext;
import org.teiid.query.processor.xml.XMLProcessorEnvironment;

public class ExecStagingTableInstruction
extends ExecSqlInstruction {
    public ExecStagingTableInstruction(String resultName, ResultSetInfo info) {
        super(resultName, info);
    }

    @Override
    public XMLContext process(XMLProcessorEnvironment env, XMLContext context) throws BlockedException, TeiidComponentException, TeiidProcessingException {
        if (!env.isStagingTableLoaded(this.resultSetName)) {
            super.execute(env, context);
            env.markStagingTableAsLoaded(this.resultSetName);
            context.removeResultExecutor(this.resultSetName);
        }
        env.incrementCurrentProgramCounter();
        return context;
    }

    @Override
    public String toString() {
        return "STAGING:" + this.resultSetName;
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = new PlanNode("Staging Table");
        props.addProperty("Result Set", this.resultSetName);
        props.addProperty("Is Staging Flag", "true");
        props.addProperty("Query", this.info.getPlan().getDescriptionProperties());
        return props;
    }
}

