/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import org.teiid.query.QueryPlugin;
import org.teiid.query.sql.lang.PredicateCriteria;
import org.teiid.query.sql.symbol.Expression;

public abstract class AbstractCompareCriteria
extends PredicateCriteria
implements PredicateCriteria.Negatable {
    public static final int EQ = 1;
    public static final int NE = 2;
    public static final int LT = 3;
    public static final int GT = 4;
    public static final int LE = 5;
    public static final int GE = 6;
    private Expression leftExpression;
    private int operator = 1;

    public int getOperator() {
        return this.operator;
    }

    public void setOperator(int operator) {
        if (operator < 1 || operator > 6) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0001", new Object[]{operator}));
        }
        this.operator = operator;
    }

    public static int getOperator(String op) {
        if (op.equals("=")) {
            return 1;
        }
        if (op.equals("<>")) {
            return 2;
        }
        if (op.equals("<>")) {
            return 2;
        }
        if (op.equals("<")) {
            return 3;
        }
        if (op.equals(">")) {
            return 4;
        }
        if (op.equals("<=")) {
            return 5;
        }
        if (op.equals(">=")) {
            return 6;
        }
        return -1;
    }

    public void setLeftExpression(Expression expression) {
        this.leftExpression = expression;
    }

    public Expression getLeftExpression() {
        return this.leftExpression;
    }

    public abstract Expression getRightExpression();

    public String getOperatorAsString() {
        switch (this.operator) {
            case 1: {
                return "=";
            }
            case 2: {
                return "<>";
            }
            case 3: {
                return "<";
            }
            case 4: {
                return ">";
            }
            case 5: {
                return "<=";
            }
            case 6: {
                return ">=";
            }
        }
        return "??";
    }

    @Override
    public void negate() {
        this.setOperator(AbstractCompareCriteria.getInverseOperator(this.getOperator()));
    }

    public static int getInverseOperator(int op) {
        switch (op) {
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 6;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 3;
            }
        }
        return -1;
    }
}

