/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.binary;

import nu.xom.Attribute;
import nu.xom.Element;
import nux.xom.binary.LRUHashMap2;

public final class NodeBuilder {
    private final LRUHashMap2 elements;
    private final LRUHashMap2 attributes;

    public NodeBuilder() {
        this(512);
    }

    private NodeBuilder(int maxSize) {
        this.elements = new LRUHashMap2(maxSize);
        this.attributes = new LRUHashMap2(maxSize);
    }

    public Element createElement(String qname, String uri) {
        Element elem;
        if (uri == null) {
            uri = "";
        }
        if ((elem = (Element)this.elements.get(qname, uri)) == null) {
            elem = new Element(qname, uri);
            this.elements.put(qname, uri, elem);
        }
        return new Element(elem);
    }

    public Attribute createAttribute(String qname, String uri, String value, Attribute.Type type) {
        Attribute attr;
        if (uri == null) {
            uri = "";
        }
        if ("xml:id".equals(qname)) {
            type = Attribute.Type.ID;
        }
        if ((attr = (Attribute)this.attributes.get(qname, uri)) == null) {
            attr = new Attribute(qname, uri, value, type);
            this.attributes.put(qname, uri, attr);
            return new Attribute(attr);
        }
        if ((attr = new Attribute(attr)).getType() != type) {
            attr.setType(type);
        }
        attr.setValue(value);
        return attr;
    }
}

