/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.ProcessingInstruction;
import nu.xom.Serializer;
import nu.xom.Text;
import nux.xom.io.NamespacesInScope;
import nux.xom.io.StreamingSerializer;
import nux.xom.io.StreamingVerifier;

final class StreamingXMLSerializer
extends Serializer
implements StreamingSerializer {
    private final StreamingVerifier verifier = new StreamingVerifier();
    private final NamespacesInScope namespaces = new NamespacesInScope();
    private static final boolean EXPAND_EMPTY_ELEMENTS = true;
    private Element startTag = null;
    private boolean hasChildren = false;
    private static final boolean DEBUG = false;
    private boolean calledFromSuperclass = false;
    private static final Document EMPTY_DOCUMENT = new EmptyDocument();

    public StreamingXMLSerializer(OutputStream out) {
        super(out);
    }

    public StreamingXMLSerializer(OutputStream out, String encoding) throws UnsupportedEncodingException {
        super(out, encoding);
    }

    private void clear() {
        this.verifier.reset();
        this.namespaces.reset();
        this.startTag = null;
        this.hasChildren = false;
    }

    public void setOutputStream(OutputStream out) throws IOException {
        super.setOutputStream(out);
        this.clear();
    }

    public void writeStartTag(Element elem) throws IOException {
        this.verifier.writeStartTag(elem);
        this.namespaces.push();
        super.writeStartTag(elem);
    }

    private void writeDelayedStartTag() throws IOException {
    }

    public void writeEndTag() throws IOException {
        Element elem = this.verifier.writeEndTag();
        this.writeEndTag(elem);
        this.namespaces.pop();
        this.hasChildren = true;
    }

    protected void writeNamespaceDeclarations(Element elem) throws IOException {
        int count = elem.getNamespaceDeclarationCount();
        int i = 0;
        while (i < count) {
            String uri;
            String prefix = elem.getNamespacePrefix(i);
            if (this.namespaces.addIfAbsent(prefix, uri = elem.getNamespaceURI(prefix))) {
                this.writeRaw(" ");
                this.writeNamespaceDeclaration(prefix, uri);
            }
            ++i;
        }
    }

    public void write(Document doc) throws IOException {
        super.write(doc);
        this.writeEndDocument();
    }

    public void write(Element element) throws IOException {
        this.writeStartTag(element);
        int i = 0;
        while (i < element.getChildCount()) {
            this.writeChild(element.getChild(i));
            ++i;
        }
        this.writeEndTag();
    }

    public void write(Text text) throws IOException {
        this.verifier.write(text);
        String value = text.getValue();
        if (value.length() > 0) {
            this.writeDelayedStartTag();
            this.writeEscaped(value);
        }
    }

    public void write(Comment comment) throws IOException {
        this.verifier.write(comment);
        this.writeDelayedStartTag();
        super.write(comment);
    }

    public void write(ProcessingInstruction instruction) throws IOException {
        this.verifier.write(instruction);
        this.writeDelayedStartTag();
        super.write(instruction);
    }

    public void write(DocType docType) throws IOException {
        this.verifier.write(docType);
        super.write(docType);
    }

    public void writeEndDocument() throws IOException {
        int i = this.verifier.depth();
        while (--i >= 0) {
            this.writeEndTag();
        }
        this.verifier.writeEndDocument();
        this.flush();
        this.clear();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeXMLDeclaration() throws IOException {
        if (this.calledFromSuperclass) {
            super.writeXMLDeclaration();
            return;
        }
        this.verifier.writeXMLDeclaration();
        this.clear();
        this.verifier.writeXMLDeclaration();
        this.calledFromSuperclass = true;
        try {
            super.write(EMPTY_DOCUMENT);
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.calledFromSuperclass = false;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.calledFromSuperclass = false;
            return;
        }
    }

    private static final class EmptyDocument
    extends Document {
        private EmptyDocument() {
            super(new Element("dummy"));
        }

        public int getChildCount() {
            return 0;
        }
    }
}

