/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.pool;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.ParsingException;
import nux.xom.pool.BuilderPool;
import nux.xom.pool.XOMUtil;

public class DocumentFactory {
    public Document createDocument(File input) throws ParsingException, IOException {
        return this.createDocument(new FileInputStream(input), input.toURI());
    }

    public Document createDocument(InputStream input, URI baseURI) throws ParsingException, IOException {
        Document document;
        block6: {
            Builder builder;
            block4: {
                Document document2;
                block5: {
                    try {
                        if (input == null && baseURI == null) {
                            throw new IllegalArgumentException("input and baseURI must not both be null");
                        }
                        builder = this.newBuilder();
                        if (baseURI != null) break block4;
                        document2 = builder.build(input);
                        Object var4_6 = null;
                        if (input == null) break block5;
                    }
                    catch (Throwable throwable) {
                        block7: {
                            Object var4_8 = null;
                            if (input == null) break block7;
                            input.close();
                        }
                        throw throwable;
                    }
                    input.close();
                }
                return document2;
            }
            document = builder.build(input, baseURI.toASCIIString());
            Object var4_7 = null;
            if (input == null) break block6;
            input.close();
        }
        return document;
    }

    protected Builder newBuilder() {
        return BuilderPool.GLOBAL_POOL.getBuilder(false);
    }

    public DocumentFactory getBinaryXMLFactory() {
        return new BinaryXMLDocumentFactory(this);
    }

    private static final class BinaryXMLDocumentFactory
    extends DocumentFactory {
        private final DocumentFactory parent;

        private BinaryXMLDocumentFactory(DocumentFactory parent) {
            this.parent = parent;
        }

        public Document createDocument(InputStream input, URI baseURI) throws ParsingException, IOException {
            Document document;
            if (input == null && baseURI == null) {
                throw new IllegalArgumentException("input and baseURI must not both be null");
            }
            if (input == null) {
                input = baseURI.toURL().openStream();
            }
            try {
                Document doc = XOMUtil.getBinaryXMLCodec().deserialize(input, null);
                if (baseURI != null) {
                    doc.setBaseURI(baseURI.toASCIIString());
                }
                document = doc;
                Object var4_5 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                input.close();
                throw throwable;
            }
            input.close();
            return document;
        }
    }
}

