/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.sandbox;

import java.util.ArrayList;
import java.util.Arrays;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.IllegalAddException;
import nu.xom.Node;
import nu.xom.NodeFactory;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.WellformednessException;
import nu.xom.XMLException;

public final class MulticastNodeFactory
extends NodeFactory {
    private final NodeFactory[] receivers;
    private final RuntimeException[] exceptions;
    private final ParentNode[] currents;
    private final ArrayList[] stacks;
    private final boolean[] addAttributesAndNamespaces;
    private final boolean[] hasRootElement;
    private final boolean failFast;
    private final Nodes NONE = new Nodes();

    public MulticastNodeFactory(NodeFactory[] receivers, boolean failFast) {
        if (receivers == null) {
            throw new IllegalArgumentException("factories must not be null");
        }
        int i = 0;
        while (i < receivers.length) {
            if (receivers[i] == null) {
                throw new IllegalArgumentException("factory must not be null");
            }
            ++i;
        }
        this.receivers = new NodeFactory[receivers.length];
        System.arraycopy(receivers, 0, this.receivers, 0, receivers.length);
        this.exceptions = new RuntimeException[receivers.length];
        this.currents = new ParentNode[receivers.length];
        this.stacks = new ArrayList[receivers.length];
        this.addAttributesAndNamespaces = new boolean[receivers.length];
        this.hasRootElement = new boolean[receivers.length];
        this.failFast = failFast;
        this.reset();
    }

    private void reset() {
        Arrays.fill(this.exceptions, null);
        Arrays.fill(this.currents, null);
        int i = 0;
        while (i < this.stacks.length) {
            if (this.stacks[i] == null) {
                this.stacks[i] = new ArrayList();
            }
            this.stacks[i].clear();
            ++i;
        }
        Arrays.fill(this.addAttributesAndNamespaces, true);
        Arrays.fill(this.hasRootElement, false);
    }

    public Document[] getDocuments() {
        Document[] documents = new Document[this.currents.length];
        int i = 0;
        while (i < this.currents.length) {
            documents[i] = (Document)this.currents[i];
            ++i;
        }
        return documents;
    }

    private void onException(int i, RuntimeException e) {
        this.exceptions[i] = e;
        if (this.failFast) {
            throw e;
        }
    }

    public Document startMakingDocument() {
        this.reset();
        int i = 0;
        while (i < this.receivers.length) {
            if (this.exceptions[i] == null) {
                try {
                    this.currents[i] = this.receivers[i].startMakingDocument();
                    if (this.currents[i] == null) {
                        throw new NullPointerException("startMakingDocument must not return null.");
                    }
                }
                catch (RuntimeException e) {
                    this.onException(i, e);
                }
            }
            ++i;
        }
        return super.startMakingDocument();
    }

    public void finishMakingDocument(Document doc) {
        int i = 0;
        while (i < this.receivers.length) {
            if (this.exceptions[i] == null) {
                try {
                    this.receivers[i].finishMakingDocument((Document)this.currents[i]);
                    if (!this.hasRootElement[i]) {
                        throw new WellformednessException("Factory attempted to remove the root element");
                    }
                }
                catch (RuntimeException e) {
                    this.onException(i, e);
                }
            }
            ++i;
        }
        super.finishMakingDocument(doc);
        i = 0;
        while (!this.failFast && i < this.receivers.length) {
            if (this.exceptions[i] != null) {
                throw new MultipleCausesException(this.exceptions);
            }
            ++i;
        }
    }

    public Element makeRootElement(String qname, String namespaceURI) {
        int i = 0;
        while (i < this.receivers.length) {
            if (this.exceptions[i] == null) {
                try {
                    Element elem = this.receivers[i].makeRootElement(qname, namespaceURI);
                    if (elem == null) {
                        throw new NullPointerException("Factory failed to create root element.");
                    }
                    this.stacks[i].add(elem);
                    ((Document)this.currents[i]).setRootElement(elem);
                    this.currents[i] = elem;
                    this.addAttributesAndNamespaces[i] = true;
                }
                catch (RuntimeException e) {
                    this.onException(i, e);
                }
            }
            ++i;
        }
        return new Element(qname, namespaceURI);
    }

    public Element startMakingElement(String qname, String namespaceURI) {
        int i = 0;
        while (i < this.receivers.length) {
            if (this.exceptions[i] == null) {
                try {
                    Element elem = this.receivers[i].startMakingElement(qname, namespaceURI);
                    this.stacks[i].add(elem);
                    if (elem != null) {
                        this.currents[i].insertChild((Node)elem, this.currents[i].getChildCount());
                        this.currents[i] = elem;
                    }
                    this.addAttributesAndNamespaces[i] = elem != null;
                }
                catch (RuntimeException e) {
                    this.onException(i, e);
                }
            }
            ++i;
        }
        return new Element(qname, namespaceURI);
    }

    public Nodes finishMakingElement(Element unused) {
        int i = 0;
        while (i < this.receivers.length) {
            if (this.exceptions[i] == null) {
                try {
                    Element elem = (Element)this.stacks[i].remove(this.stacks[i].size() - 1);
                    if (elem != null) {
                        ParentNode parent = elem.getParent();
                        if (parent == null) {
                            MulticastNodeFactory.throwTamperedWithParent();
                        }
                        this.currents[i] = parent;
                        Nodes nodes = this.receivers[i].finishMakingElement(elem);
                        if (nodes.size() == 1 && nodes.get(0) == elem) {
                            if (parent instanceof Document) {
                                this.hasRootElement[i] = true;
                            }
                        } else {
                            if (parent.getChildCount() - 1 < 0) {
                                MulticastNodeFactory.throwTamperedWithParent();
                            }
                            if (parent instanceof Element) {
                                parent.removeChild(parent.getChildCount() - 1);
                            }
                            this.appendNodes(parent, nodes, i);
                        }
                    }
                }
                catch (RuntimeException e) {
                    this.onException(i, e);
                }
            }
            ++i;
        }
        if (unused.getParent() instanceof Document) {
            return new Nodes((Node)unused);
        }
        return this.NONE;
    }

    public Nodes makeAttribute(String qname, String namespaceURI, String value, Attribute.Type type) {
        int i = 0;
        while (i < this.receivers.length) {
            if (this.exceptions[i] == null && this.addAttributesAndNamespaces[i]) {
                try {
                    Nodes nodes = this.receivers[i].makeAttribute(qname, namespaceURI, value, type);
                    this.appendNodes(this.currents[i], nodes, i);
                }
                catch (RuntimeException e) {
                    this.onException(i, e);
                }
            }
            ++i;
        }
        return this.NONE;
    }

    public Nodes makeComment(String data) {
        int i = 0;
        while (i < this.receivers.length) {
            if (this.exceptions[i] == null) {
                try {
                    Nodes nodes = this.receivers[i].makeText(data);
                    this.appendNodes(this.currents[i], nodes, i);
                }
                catch (RuntimeException e) {
                    this.onException(i, e);
                }
            }
            ++i;
        }
        return this.NONE;
    }

    public Nodes makeDocType(String rootElementName, String publicID, String systemID) {
        int i = 0;
        while (i < this.receivers.length) {
            if (this.exceptions[i] == null) {
                try {
                    Nodes nodes = this.receivers[i].makeDocType(rootElementName, publicID, systemID);
                    this.appendNodes(this.currents[i], nodes, i);
                }
                catch (RuntimeException e) {
                    this.onException(i, e);
                }
            }
            ++i;
        }
        return this.NONE;
    }

    public Nodes makeProcessingInstruction(String target, String data) {
        int i = 0;
        while (i < this.receivers.length) {
            if (this.exceptions[i] == null) {
                try {
                    Nodes nodes = this.receivers[i].makeProcessingInstruction(target, data);
                    this.appendNodes(this.currents[i], nodes, i);
                }
                catch (RuntimeException e) {
                    this.onException(i, e);
                }
            }
            ++i;
        }
        return this.NONE;
    }

    public Nodes makeText(String text) {
        int i = 0;
        while (i < this.receivers.length) {
            if (this.exceptions[i] == null) {
                try {
                    Nodes nodes = this.receivers[i].makeText(text);
                    this.appendNodes(this.currents[i], nodes, i);
                }
                catch (RuntimeException e) {
                    this.onException(i, e);
                }
            }
            ++i;
        }
        return this.NONE;
    }

    private void appendNodes(ParentNode parent, Nodes nodes, int k) {
        if (parent instanceof Element) {
            MulticastNodeFactory.appendNodesToElement((Element)parent, nodes);
        } else {
            this.appendNodesToDocument((Document)parent, nodes, k);
        }
    }

    private static void appendNodesToElement(Element elem, Nodes nodes) {
        if (nodes != null) {
            int size = nodes.size();
            int i = 0;
            while (i < size) {
                Node node = nodes.get(i);
                if (node instanceof Attribute) {
                    elem.addAttribute((Attribute)node);
                } else {
                    elem.insertChild(node, elem.getChildCount());
                }
                ++i;
            }
        }
    }

    private void appendNodesToDocument(Document doc, Nodes nodes, int k) {
        if (nodes != null) {
            int size = nodes.size();
            int i = 0;
            while (i < size) {
                Node node = nodes.get(i);
                if (node instanceof Element) {
                    if (this.hasRootElement[k]) {
                        throw new IllegalAddException("Factory returned multiple root elements");
                    }
                    doc.setRootElement((Element)node);
                    this.hasRootElement[k] = true;
                } else {
                    int j = doc.getChildCount();
                    if (!this.hasRootElement[k]) {
                        --j;
                    }
                    doc.insertChild(node, j);
                }
                ++i;
            }
        }
    }

    private static void throwTamperedWithParent() {
        throw new XMLException("Factory has tampered with a parent pointer of ancestor-or-self in finishMakingElement()");
    }

    public static final class MultipleCausesException
    extends RuntimeException {
        private final Throwable[] causes;

        private MultipleCausesException(Throwable[] causes) {
            this.causes = new Throwable[causes.length];
            System.arraycopy(causes, 0, this.causes, 0, causes.length);
        }

        public Throwable[] getCauses() {
            return this.causes;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < this.causes.length) {
                buf.append("Cause " + i + ": ");
                buf.append(this.causes[i]);
                if (i < this.causes.length - 1) {
                    buf.append("\n");
                }
                ++i;
            }
            return buf.toString();
        }
    }
}

