/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.sandbox;

import java.io.File;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Node;
import nux.xom.pool.XOMUtil;
import nux.xom.xquery.XQueryUtil;

public class XQueryUpdateTest {
    private int count = 0;

    private XQueryUpdateTest() {
    }

    public static void main(String[] args) throws Exception {
        new XQueryUpdateTest().run(args);
    }

    private void run(String[] args) throws Exception {
        Document doc = new Builder().build(new File("samples/data/articles.xml"));
        System.out.println("input=\n" + XOMUtil.toPrettyXML((Node)doc));
        this.update((Node)doc, "//node() | //@*", ".", "identity transform");
        this.update((Node)doc, "//@*", "()", "delete all attributes");
        this.update((Node)doc, "//article[@name='chair']", "()", "delete all chairs");
        this.update((Node)doc, "//article", "if (@name='chair') then () else .", "delete all chairs (equivalent)");
        this.update((Node)doc, "//article/@onStock[../@name='chair']", "()", "delete stock info of chairs");
        this.update((Node)doc, "//article[@name='chair']/prize", "9.5", "set prize of chair to 9.5");
        this.update((Node)doc, "//article[@name='chair']/@onStock", "0", "set attribute value to 0");
        this.update((Node)doc, "//article[@name='chair']/@onStock", ". + 50", "increment attribute value by 50");
        this.update((Node)doc, "//article/prize", ". * 0.95", "make all articles a bit cheaper");
        this.update((Node)doc, "//article[1]", "(//article[2], .)", "move article position: move second article before first article");
        this.update((Node)doc, "/articles/article[last()]", "(., <foo/>, <article name='sofa' onStock='40'> <prize>30.0</prize> <quantity>500</quantity> </article>)", "append some new elements at end");
        this.update((Node)doc, "//@onStock", "attribute {'availability'} { string(.) }", "rename an attribute");
        this.update((Node)doc, "//article/prize", "<price>{string(.)}</price>", "rename an element");
        this.update((Node)doc, "//article/prize", "attribute {'price'} {string(.)}", "turn an element into an attribute");
        this.update((Node)doc, "/*", "(comment {'database of articles on stock'}, ., comment {'end of database'} )", "add comments before and after root element");
        this.update((Node)doc, "//article", "prize", "delete all articles, only retaining their prize");
        this.update((Node)doc, "//article", "<envelope total='{prize * quantity}'>{.}</envelope>", "wrap each article into a new element with a derived attribute");
        this.update((Node)doc, "//article/*[1]", "(<summary total='{../prize * ../quantity}'></summary>, .)", "add a summary element to each article");
        this.update((Node)doc, "//article", "(comment {index-of(../*, .)}, .)", "add item number ID comment before each article");
        this.update((Node)doc, "//article/*[1]", "(., attribute {'id'} {index-of(../../*, ..)} )", "add item number ID attribute to each article");
    }

    private void update(Node contextNode, String select, String morpher, String msg) {
        contextNode = contextNode.copy();
        XQueryUtil.update(contextNode, select, morpher);
        System.out.println("\nQ" + this.count + ": " + msg + ": update(" + select + ", " + morpher + ")\noutput=\n" + XOMUtil.toPrettyXML(contextNode));
        ++this.count;
    }
}

