/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index.memory;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.PorterStemFilter;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.memory.SynonymMap;
import org.apache.lucene.index.memory.SynonymTokenFilter;

public class AnalyzerUtil {
    private static final Pattern PARAGRAPHS = Pattern.compile("([\\r\\n\\u0085\\u2028\\u2029][ \\t\\x0B\\f]*){2,}");
    private static final Pattern SENTENCES = Pattern.compile("[!\\.\\?\\xA1\\xBF]+");

    private AnalyzerUtil() {
    }

    public static Analyzer getLoggingAnalyzer(final Analyzer child, final PrintStream log, final String logName) {
        if (child == null) {
            throw new IllegalArgumentException("child analyzer must not be null");
        }
        if (log == null) {
            throw new IllegalArgumentException("logStream must not be null");
        }
        return new Analyzer(){

            public TokenStream tokenStream(String fieldName, Reader reader) {
                return new TokenFilter(this, child.tokenStream(fieldName, reader), log, logName, fieldName){
                    private int position;
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ PrintStream val$log;
                    private final /* synthetic */ String val$logName;
                    private final /* synthetic */ String val$fieldName;
                    {
                        this.this$1 = var1_1;
                        this.val$log = printStream;
                        this.val$logName = string;
                        this.val$fieldName = string2;
                        this.position = -1;
                    }

                    public Token next() throws IOException {
                        Token token = this.input.next();
                        this.val$log.println(this.toString(token));
                        return token;
                    }

                    private String toString(Token token) {
                        if (token == null) {
                            return "[" + this.val$logName + ":EOS:" + this.val$fieldName + "]\n";
                        }
                        this.position += token.getPositionIncrement();
                        return "[" + this.val$logName + ":" + this.position + ":" + this.val$fieldName + ":" + token.termText() + ":" + token.startOffset() + "-" + token.endOffset() + ":" + token.type() + "]";
                    }
                };
            }
        };
    }

    public static Analyzer getMaxTokenAnalyzer(final Analyzer child, final int maxTokens) {
        if (child == null) {
            throw new IllegalArgumentException("child analyzer must not be null");
        }
        if (maxTokens < 0) {
            throw new IllegalArgumentException("maxTokens must not be negative");
        }
        if (maxTokens == Integer.MAX_VALUE) {
            return child;
        }
        return new Analyzer(){

            public TokenStream tokenStream(String fieldName, Reader reader) {
                return new TokenFilter(this, child.tokenStream(fieldName, reader), maxTokens){
                    private int todo;
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                        this.todo = n;
                    }

                    public Token next() throws IOException {
                        return --this.todo >= 0 ? this.input.next() : null;
                    }
                };
            }
        };
    }

    public static Analyzer getPorterStemmerAnalyzer(final Analyzer child) {
        if (child == null) {
            throw new IllegalArgumentException("child analyzer must not be null");
        }
        return new Analyzer(){

            public TokenStream tokenStream(String fieldName, Reader reader) {
                return new PorterStemFilter(child.tokenStream(fieldName, reader));
            }
        };
    }

    public static Analyzer getSynonymAnalyzer(final Analyzer child, final SynonymMap synonyms, final int maxSynonyms) {
        if (child == null) {
            throw new IllegalArgumentException("child analyzer must not be null");
        }
        if (synonyms == null) {
            throw new IllegalArgumentException("synonyms must not be null");
        }
        if (maxSynonyms < 0) {
            throw new IllegalArgumentException("maxSynonyms must not be negative");
        }
        if (maxSynonyms == 0) {
            return child;
        }
        return new Analyzer(){

            public TokenStream tokenStream(String fieldName, Reader reader) {
                return new SynonymTokenFilter(child.tokenStream(fieldName, reader), synonyms, maxSynonyms);
            }
        };
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] getMostFrequentTerms(Analyzer analyzer, String text, int limit) {
        if (analyzer == null) {
            throw new IllegalArgumentException("analyzer must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("text must not be null");
        }
        if (limit <= 0) {
            limit = Integer.MAX_VALUE;
        }
        HashMap<String, MutableInteger> map = new HashMap<String, MutableInteger>();
        TokenStream stream = analyzer.tokenStream("", (Reader)new StringReader(text));
        try {
            try {
                Token token;
                while ((token = stream.next()) != null) {
                    MutableInteger freq = (MutableInteger)map.get(token.termText());
                    if (freq == null) {
                        freq = new MutableInteger(1);
                        map.put(token.termText(), freq);
                        continue;
                    }
                    freq.setValue(freq.intValue() + 1);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }
        {
            Object var7_12 = null;
        }
        try {}
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        stream.close();
        Map.Entry[] entries = new Map.Entry[map.size()];
        map.entrySet().toArray(entries);
        Arrays.sort(entries, new Comparator(){

            public int compare(Object o1, Object o2) {
                Map.Entry e1 = (Map.Entry)o1;
                Map.Entry e2 = (Map.Entry)o2;
                int f1 = ((MutableInteger)e1.getValue()).intValue();
                int f2 = ((MutableInteger)e2.getValue()).intValue();
                if (f2 - f1 != 0) {
                    return f2 - f1;
                }
                String s1 = (String)e1.getKey();
                String s2 = (String)e2.getKey();
                return s1.compareTo(s2);
            }
        });
        int size = Math.min(limit, entries.length);
        String[] pairs = new String[size];
        int i = 0;
        while (i < size) {
            pairs[i] = entries[i].getValue() + ":" + entries[i].getKey();
            ++i;
        }
        return pairs;
    }

    public static String[] getParagraphs(String text, int limit) {
        return AnalyzerUtil.tokenize(PARAGRAPHS, text, limit);
    }

    private static String[] tokenize(Pattern pattern, String text, int limit) {
        String[] tokens = pattern.split(text, limit);
        int i = tokens.length;
        while (--i >= 0) {
            tokens[i] = tokens[i].trim();
        }
        return tokens;
    }

    public static String[] getSentences(String text, int limit) {
        int len = text.length();
        if (len == 0) {
            return new String[]{text};
        }
        if (limit <= 0) {
            limit = Integer.MAX_VALUE;
        }
        String[] tokens = new String[Math.min(limit, 1 + len / 40)];
        int size = 0;
        int i = 0;
        while (i < len && size < limit) {
            int start = i;
            while (i < len && !AnalyzerUtil.isSentenceSeparator(text.charAt(i))) {
                ++i;
            }
            if (size == tokens.length) {
                String[] tmp = new String[tokens.length << 1];
                System.arraycopy(tokens, 0, tmp, 0, size);
                tokens = tmp;
            }
            tokens[size++] = text.substring(start, i).trim();
            while (i < len && AnalyzerUtil.isSentenceSeparator(text.charAt(i))) {
                ++i;
            }
        }
        if (size == tokens.length) {
            return tokens;
        }
        String[] results = new String[size];
        System.arraycopy(tokens, 0, results, 0, size);
        return results;
    }

    private static boolean isSentenceSeparator(char c) {
        switch (c) {
            case '!': {
                return true;
            }
            case '.': {
                return true;
            }
            case '?': {
                return true;
            }
            case '\u00a1': {
                return true;
            }
            case '\u00bf': {
                return true;
            }
        }
        return false;
    }

    private static final class MutableInteger {
        private int value;

        public MutableInteger(int value) {
            this.value = value;
        }

        public int intValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

