/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.fop.render.afp.modca.AbstractAFPObject;
import org.apache.fop.render.afp.modca.AbstractNamedAFPObject;
import org.apache.fop.render.afp.modca.PageGroup;
import org.apache.fop.render.afp.modca.PageObject;

public final class Document
extends AbstractNamedAFPObject {
    private static final String DEFAULT_NAME = "DOC00001";
    private List objects = new ArrayList();
    private boolean started = false;
    private boolean complete = false;

    public Document() {
        this(DEFAULT_NAME);
    }

    public Document(String name) {
        super(name);
    }

    public void addPage(PageObject page) {
        if (!this.objects.contains(page)) {
            this.objects.add(page);
        }
    }

    public void addPageGroup(PageGroup pageGroup) {
        this.objects.add(pageGroup);
    }

    public void endDocument() {
        this.complete = true;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void writeDataStream(OutputStream os) throws IOException {
        AbstractAFPObject ao;
        if (!this.started) {
            this.writeStart(os);
            this.started = true;
        }
        Iterator it = this.objects.iterator();
        while (it.hasNext() && ((ao = (AbstractAFPObject)it.next()) instanceof PageObject && ((PageObject)ao).isComplete() || ao instanceof PageGroup && ((PageGroup)ao).isComplete())) {
            ao.writeDataStream(os);
            it.remove();
        }
        if (this.complete) {
            this.writeEnd(os);
        }
    }

    private void writeStart(OutputStream os) throws IOException {
        byte[] data = new byte[17];
        data[0] = 90;
        data[1] = 0;
        data[2] = 16;
        data[3] = -45;
        data[4] = -88;
        data[5] = -88;
        data[6] = 0;
        data[7] = 0;
        data[8] = 0;
        for (int i = 0; i < this.nameBytes.length; ++i) {
            data[9 + i] = this.nameBytes[i];
        }
        os.write(data);
    }

    private void writeEnd(OutputStream os) throws IOException {
        byte[] data = new byte[17];
        data[0] = 90;
        data[1] = 0;
        data[2] = 16;
        data[3] = -45;
        data[4] = -87;
        data[5] = -88;
        data[6] = 0;
        data[7] = 0;
        data[8] = 0;
        for (int i = 0; i < this.nameBytes.length; ++i) {
            data[9 + i] = this.nameBytes[i];
        }
        os.write(data);
    }
}

