/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.file;

import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.spi.InvalidPropertyException;
import org.teiid.core.BundleUtil;
import org.teiid.core.util.StringUtil;
import org.teiid.resource.adapter.file.FileConnectionImpl;
import org.teiid.resource.spi.BasicConnectionFactory;
import org.teiid.resource.spi.BasicManagedConnectionFactory;

public class FileManagedConnectionFactory
extends BasicManagedConnectionFactory {
    private static final long serialVersionUID = -1495488034205703625L;
    public static final BundleUtil UTIL = BundleUtil.getBundleUtil(FileManagedConnectionFactory.class);
    private String parentDirectory;
    private String fileMapping;
    private boolean allowParentPaths = true;

    public BasicConnectionFactory<FileConnectionImpl> createConnectionFactory() throws ResourceException {
        if (this.parentDirectory == null) {
            throw new InvalidPropertyException(UTIL.getString("parentdirectory_not_set"));
        }
        final Map map = (Map)StringUtil.valueOf((String)this.fileMapping, Map.class);
        return new BasicConnectionFactory<FileConnectionImpl>(){

            public FileConnectionImpl getConnection() throws ResourceException {
                return new FileConnectionImpl(FileManagedConnectionFactory.this.parentDirectory, map, FileManagedConnectionFactory.this.allowParentPaths);
            }
        };
    }

    public String getParentDirectory() {
        return this.parentDirectory;
    }

    public void setParentDirectory(String parentDirectory) {
        this.parentDirectory = parentDirectory;
    }

    public String getFileMapping() {
        return this.fileMapping;
    }

    public void setFileMapping(String fileMapping) {
        this.fileMapping = fileMapping;
    }

    public Boolean isAllowParentPaths() {
        return this.allowParentPaths;
    }

    public void setAllowParentPaths(Boolean allowParentPaths) {
        this.allowParentPaths = allowParentPaths;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.allowParentPaths ? 1231 : 1237);
        result = 31 * result + (this.fileMapping == null ? 0 : this.fileMapping.hashCode());
        result = 31 * result + (this.parentDirectory == null ? 0 : this.parentDirectory.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        FileManagedConnectionFactory other = (FileManagedConnectionFactory)((Object)obj);
        if (this.allowParentPaths != other.allowParentPaths) {
            return false;
        }
        if (!FileManagedConnectionFactory.checkEquals((Object)this.fileMapping, (Object)other.fileMapping)) {
            return false;
        }
        return FileManagedConnectionFactory.checkEquals((Object)this.parentDirectory, (Object)other.parentDirectory);
    }
}

