/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.Serializable;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.ContextSwitchingExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.GeneralComparison;
import net.sf.saxon.expr.GeneralComparison10;
import net.sf.saxon.expr.PathExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.ApplyTemplates;
import net.sf.saxon.instruct.Choose;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.sort.DocumentSorter;
import net.sf.saxon.trans.RuleTarget;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.MemoClosure;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;

public class Optimizer
implements Serializable {
    public static final int NO_OPTIMIZATION = 0;
    public static final int FULL_OPTIMIZATION = 10;
    protected Configuration config;
    private int optimizationLevel = 10;

    public Optimizer(Configuration config) {
        this.config = config;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setOptimizationLevel(int level) {
        if (level < 0 || level > 10) {
            throw new IllegalArgumentException("Optimization level");
        }
        this.optimizationLevel = level;
    }

    public int getOptimizationLevel() {
        return this.optimizationLevel;
    }

    public BinaryExpression simplifyGeneralComparison(GeneralComparison gc, boolean backwardsCompatible) {
        if (backwardsCompatible) {
            Expression[] operands = gc.getOperands();
            GeneralComparison10 gc10 = new GeneralComparison10(operands[0], gc.getOperator(), operands[1]);
            gc10.setAtomicComparer(gc.getAtomicComparer());
            return gc10;
        }
        return gc;
    }

    public Expression optimizeCopy(Expression select) throws XPathException {
        TypeHierarchy th = this.config.getTypeHierarchy();
        if (select.getItemType(th).isAtomicType()) {
            return select;
        }
        return null;
    }

    public Value makeClosure(Expression expression, int ref, XPathContext context) throws XPathException {
        if (ref == 1) {
            return new Closure();
        }
        return new MemoClosure();
    }

    public ValueRepresentation makeSequenceExtent(Expression expression, int ref, XPathContext context) throws XPathException {
        return SequenceExtent.makeSequenceExtent(expression.iterate(context));
    }

    public Expression convertPathExpressionToKey(PathExpression pathExp, ExpressionVisitor visitor) throws XPathException {
        return null;
    }

    public Expression tryIndexedFilter(FilterExpression f, ExpressionVisitor visitor, boolean indexFirstOperand) {
        return f;
    }

    public FilterExpression convertToFilterExpression(PathExpression pathExp, TypeHierarchy th) throws XPathException {
        return null;
    }

    public int isIndexableFilter(Expression filter) {
        return 0;
    }

    public ValueRepresentation makeIndexedValue(SequenceIterator iter) throws XPathException {
        throw new UnsupportedOperationException("Indexing requires Saxon-EE");
    }

    public boolean isVariableReplaceableByDot(Expression exp, Binding[] binding) {
        if (exp instanceof ContextSwitchingExpression) {
            Expression start = ((ContextSwitchingExpression)((Object)exp)).getControllingExpression();
            Expression step = ((ContextSwitchingExpression)((Object)exp)).getControlledExpression();
            return this.isVariableReplaceableByDot(start, binding) && !ExpressionTool.dependsOnVariable(step, binding);
        }
        Iterator<Expression> iter = exp.iterateSubExpressions();
        while (iter.hasNext()) {
            Expression sub = iter.next();
            if (this.isVariableReplaceableByDot(sub, binding)) continue;
            return false;
        }
        return true;
    }

    public Expression makeConditionalDocumentSorter(DocumentSorter sorter, PathExpression path) {
        return sorter;
    }

    public Expression tryInlineFunctionCall(UserFunctionCall functionCall, ExpressionVisitor visitor, ItemType contextItemType) {
        return functionCall;
    }

    public Expression promoteExpressionsToGlobal(Expression body, ExpressionVisitor visitor, boolean notTopLevel) throws XPathException {
        return body;
    }

    public Expression trySwitch(Choose choose, StaticContext env) {
        return choose;
    }

    public Expression extractGlobalVariables(Expression body, ExpressionVisitor visitor) throws XPathException {
        return null;
    }

    public Expression makeStreamingApplyTemplates(ApplyTemplates inst) throws XPathException {
        return inst;
    }

    public RuleTarget makeInversion(Template template, NodeTest nodeTest) throws XPathException {
        return null;
    }

    public void trace(String message, Expression exp) {
        if (this.getConfiguration().isOptimizerTracing()) {
            System.err.println("OPT ======================================");
            System.err.println("OPT : At line " + exp.getLineNumber() + " of " + exp.getSystemId());
            System.err.println("OPT : " + message);
            System.err.println("OPT ====== Expression after rewrite ======");
            exp.explain(System.err);
            System.err.println("\nOPT ======================================");
        }
    }

    public void trace(String message) {
        if (this.getConfiguration().isOptimizerTracing()) {
            System.err.println("OPT ======================================");
            System.err.println("OPT : " + message);
            System.err.println("OPT ======================================");
        }
    }
}

