/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.mock.mockbehavior.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.unitils.mock.core.proxy.ProxyInvocation;
import org.unitils.mock.dummy.DummyObjectUtil;
import org.unitils.mock.mockbehavior.impl.DefaultValueReturningMockBehavior;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DummyValueReturningMockBehavior
extends DefaultValueReturningMockBehavior {
    private Map<MethodKey, Object> returnValues = new HashMap<MethodKey, Object>();

    @Override
    public Object execute(ProxyInvocation proxyInvocation) {
        Object result = null;
        Method method = proxyInvocation.getMethod();
        Class<?> returnType = method.getReturnType();
        MethodKey key = new MethodKey(method.getName(), proxyInvocation.getArguments());
        if (this.returnValues.containsKey(key)) {
            result = this.returnValues.get(key);
        }
        if (result == null) {
            result = super.execute(proxyInvocation);
        }
        if (result == null && String.class.equals(returnType)) {
            result = "";
        }
        if (result == null && this.isDummyProof(returnType)) {
            result = DummyObjectUtil.createDummy(returnType, new DummyValueReturningMockBehavior());
        }
        this.returnValues.put(key, result);
        return result;
    }

    private boolean isDummyProof(Class<?> returnType) {
        return !returnType.isPrimitive() && returnType != Void.TYPE && !Modifier.isFinal(returnType.getModifiers());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MethodKey {
        private String methodName;
        private List<Object> arguments;

        public MethodKey(String methodName, List<Object> arguments) {
            this.methodName = methodName;
            this.arguments = arguments;
        }

        public int hashCode() {
            return this.methodName.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodKey other = (MethodKey)obj;
            if (this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName)) {
                return false;
            }
            if (this.arguments.size() != other.arguments.size()) {
                return false;
            }
            if (this.arguments.size() > 0) {
                Iterator<Object> it2 = other.arguments.iterator();
                for (Object object1 : this.arguments) {
                    Object object2 = it2.next();
                    if (object1 == null && object2 == null || object1 == null || object1.equals(object2)) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

