/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.io.Closeable;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleRootMarker;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.deployment.module.MountHandle;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

class DynamicVDBRootMountDeployer
implements DeploymentUnitProcessor {
    private static final String DYNAMIC_VDB_STRUCTURE = "-vdb.xml";

    DynamicVDBRootMountDeployer() {
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT) != null) {
            return;
        }
        String deploymentName = deploymentUnit.getName();
        VirtualFile deploymentContents = (VirtualFile)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_CONTENTS);
        if (deploymentContents == null) {
            return;
        }
        if (deploymentName.endsWith(DYNAMIC_VDB_STRUCTURE)) {
            ResourceRoot resourceRoot = new ResourceRoot(deploymentContents, null);
            ModuleRootMarker.mark((ResourceRoot)resourceRoot);
            deploymentUnit.putAttachment(Attachments.DEPLOYMENT_ROOT, (Object)resourceRoot);
            deploymentUnit.putAttachment(Attachments.MODULE_SPECIFICATION, (Object)new ModuleSpecification());
        }
    }

    public void undeploy(DeploymentUnit context) {
        ResourceRoot resourceRoot = (ResourceRoot)context.removeAttachment(Attachments.DEPLOYMENT_ROOT);
        if (resourceRoot != null) {
            MountHandle mountHandle = resourceRoot.getMountHandle();
            VFSUtils.safeClose((Closeable)mountHandle);
        }
    }
}

