/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.Collection;
import java.util.ResourceBundle;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.adminapi.impl.VDBMetadataMapper;
import org.teiid.core.BundleUtil;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.TeiidOperationHandler;
import org.teiid.jboss.TransportService;

class ListSessions
extends TeiidOperationHandler {
    protected ListSessions() {
        super("list-sessions");
    }

    @Override
    protected void executeOperation(OperationContext context, DQPCore engine, ModelNode operation) throws OperationFailedException {
        String vdbName = null;
        int version = -1;
        boolean filter = false;
        if (operation.hasDefined("vdb-version") && operation.hasDefined("vdb-name")) {
            vdbName = operation.get("vdb-name").asString();
            if (!this.isValidVDB(context, vdbName, version = operation.get("vdb-version").asInt())) {
                throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50096, new Object[]{vdbName, version})));
            }
            filter = true;
        }
        ModelNode result = context.getResult();
        for (TransportService t : this.transports) {
            Collection<SessionMetadata> sessions = t.getActiveSessions();
            for (SessionMetadata session : sessions) {
                if (filter) {
                    if (!session.getVDBName().equals(vdbName) || session.getVDBVersion() != version) continue;
                    VDBMetadataMapper.SessionMetadataMapper.INSTANCE.wrap(session, result.add());
                    continue;
                }
                VDBMetadataMapper.SessionMetadataMapper.INSTANCE.wrap(session, result.add());
            }
        }
    }

    @Override
    protected void describeParameters(ModelNode operationNode, ResourceBundle bundle) {
        operationNode.get(new String[]{"request-properties", "vdb-name", "type"}).set(ModelType.STRING);
        operationNode.get(new String[]{"request-properties", "vdb-name", "required"}).set(false);
        operationNode.get(new String[]{"request-properties", "vdb-name", "description"}).set(this.getParameterDescription(bundle, "vdb-name"));
        operationNode.get(new String[]{"request-properties", "vdb-version", "type"}).set(ModelType.INT);
        operationNode.get(new String[]{"request-properties", "vdb-version", "required"}).set(false);
        operationNode.get(new String[]{"request-properties", "vdb-version", "description"}).set(this.getParameterDescription(bundle, "vdb-version"));
        ModelNode reply = operationNode.get("reply-properties");
        reply.get("type").set(ModelType.LIST);
        VDBMetadataMapper.SessionMetadataMapper.INSTANCE.describe(reply.get("value-type"));
    }
}

