/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.renderer.impl;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.Attribute;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.awareness.TilesApplicationContextAware;
import org.apache.tiles.awareness.TilesRequestContextFactoryAware;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.context.TilesRequestContextFactory;
import org.apache.tiles.evaluator.AttributeEvaluator;
import org.apache.tiles.evaluator.AttributeEvaluatorAware;
import org.apache.tiles.renderer.AttributeRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBaseAttributeRenderer
implements AttributeRenderer,
TilesRequestContextFactoryAware,
TilesApplicationContextAware,
AttributeEvaluatorAware {
    private final Log log = LogFactory.getLog(AbstractBaseAttributeRenderer.class);
    protected TilesRequestContextFactory contextFactory;
    protected TilesApplicationContext applicationContext;
    protected AttributeEvaluator evaluator;

    @Override
    public void setRequestContextFactory(TilesRequestContextFactory contextFactory) {
        this.contextFactory = contextFactory;
    }

    @Override
    public void setApplicationContext(TilesApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public void setEvaluator(AttributeEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    @Override
    public void render(Attribute attribute, TilesRequestContext request) throws IOException {
        if (!this.isPermitted(request, attribute.getRoles())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Access to attribute denied.  User not in role '" + attribute.getRoles() + "'"));
            }
            return;
        }
        Object value = this.evaluator.evaluate(attribute, request);
        this.write(value, attribute, request);
    }

    public abstract void write(Object var1, Attribute var2, TilesRequestContext var3) throws IOException;

    protected TilesRequestContext getRequestContext(Object ... requestItems) {
        return this.contextFactory.createRequestContext(this.applicationContext, requestItems);
    }

    protected boolean isPermitted(TilesRequestContext request, Set<String> roles) {
        if (roles == null || roles.isEmpty()) {
            return true;
        }
        boolean retValue = false;
        Iterator<String> roleIt = roles.iterator();
        while (roleIt.hasNext() && !retValue) {
            retValue = request.isUserInRole(roleIt.next());
        }
        return retValue;
    }
}

