/*
 * Decompiled with CFR 0.152.
 */
package jscover.filesystem;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import jscover.Configuration;
import jscover.util.IoUtils;
import org.mozilla.javascript.CompilerEnvirons;

public class ConfigurationForFS
extends Configuration {
    public static final String HELP_PREFIX1 = "-h";
    public static final String HELP_PREFIX2 = "--help";
    public static final String EXLCUDE_PREFIX = "--exclude=";
    public static final String NO_INSTRUMENT_PREFIX = "--no-instrument=";
    public static final String BRANCH_PREFIX = "--branch";
    public static final String JS_VERSION_PREFIX = "--js-version=";
    private boolean showHelp;
    private boolean invalid;
    private boolean includeBranch = false;
    private final Set<String> noInstruments = new HashSet<String>();
    private final Set<String> excludes = new HashSet<String>();
    private File srcDir = new File(System.getProperty("user.dir"));
    private File destDir = new File(System.getProperty("user.dir"));
    private int JSVersion = 150;
    private CompilerEnvirons compilerEnvirons = new CompilerEnvirons();
    private IoUtils ioUtils = IoUtils.getInstance();

    public Boolean showHelp() {
        return this.showHelp;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public boolean isIncludeBranch() {
        return this.includeBranch;
    }

    public File getSrcDir() {
        return this.srcDir;
    }

    public File getDestDir() {
        return this.destDir;
    }

    public int getJSVersion() {
        return this.JSVersion;
    }

    public boolean skipInstrumentation(String uri) {
        for (String noInstrument : this.noInstruments) {
            if (!uri.startsWith(noInstrument)) continue;
            return true;
        }
        return false;
    }

    public boolean exclude(String path) {
        for (String exclude : this.excludes) {
            if (!path.startsWith(exclude)) continue;
            return true;
        }
        return false;
    }

    public static ConfigurationForFS parse(String[] args) {
        ConfigurationForFS configuration = new ConfigurationForFS();
        for (int i = 0; i < args.length; ++i) {
            String uri;
            String arg = args[i];
            if (arg.startsWith("-fs")) continue;
            if (arg.equals(HELP_PREFIX1) || arg.equals(HELP_PREFIX2)) {
                configuration.showHelp = true;
                return configuration;
            }
            if (arg.equals(BRANCH_PREFIX)) {
                configuration.includeBranch = true;
                continue;
            }
            if (arg.startsWith(NO_INSTRUMENT_PREFIX)) {
                uri = arg.substring(NO_INSTRUMENT_PREFIX.length());
                if (uri.startsWith("/")) {
                    uri = uri.substring(1);
                }
                configuration.noInstruments.add(uri);
                continue;
            }
            if (arg.startsWith(EXLCUDE_PREFIX)) {
                uri = arg.substring(EXLCUDE_PREFIX.length());
                if (uri.startsWith("/")) {
                    uri = uri.substring(1);
                }
                configuration.excludes.add(uri);
                continue;
            }
            if (!arg.startsWith(JS_VERSION_PREFIX)) continue;
            configuration.JSVersion = (int)(Float.valueOf(arg.substring(JS_VERSION_PREFIX.length())).floatValue() * 100.0f);
        }
        if (args.length < 3) {
            configuration.invalid = true;
            configuration.showHelp = true;
            return configuration;
        }
        configuration.srcDir = new File(args[args.length - 2]);
        configuration.destDir = new File(args[args.length - 1]);
        if (!configuration.validSourceDirectory()) {
            System.err.println(String.format("Source directory '%s' is invalid", configuration.srcDir));
            configuration.invalid = true;
            configuration.showHelp = true;
        } else if (!configuration.validDestinationDirectory()) {
            System.err.println(String.format("Destination directory '%s' must not be in the source directory", configuration.destDir));
            configuration.invalid = true;
            configuration.showHelp = true;
        }
        configuration.compilerEnvirons.setLanguageVersion(configuration.JSVersion);
        return configuration;
    }

    private boolean validSourceDirectory() {
        return this.srcDir.exists() && this.srcDir.isDirectory();
    }

    boolean validDestinationDirectory() {
        try {
            return !(this.destDir.getCanonicalPath() + File.separator).startsWith(this.srcDir.getCanonicalPath() + File.separator);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getHelpText() {
        return this.ioUtils.toString(this.getClass().getResourceAsStream("help.txt"));
    }

    public CompilerEnvirons getCompilerEnvirons() {
        return this.compilerEnvirons;
    }
}

