/*
 * Decompiled with CFR 0.152.
 */
package jscover.filesystem;

import java.io.File;
import jscover.filesystem.ConfigurationForFS;
import jscover.format.PlainFormatter;
import jscover.format.SourceFormatter;
import jscover.instrument.InstrumenterService;
import jscover.util.IoService;
import jscover.util.IoUtils;
import jscover.util.Logger;

public class FileSystemInstrumenter {
    private SourceFormatter sourceFormatter = PlainFormatter.getInstance();
    private IoService ioService = new IoService();
    private InstrumenterService instrumenterService = new InstrumenterService();
    private IoUtils ioUtils = IoUtils.getInstance();
    private ConfigurationForFS configuration;
    private File log;

    public void run(ConfigurationForFS configuration) {
        this.configuration = configuration;
        this.log = new File(configuration.getDestDir(), "errors.log");
        Logger.setLogFile(this.log);
        this.ioService.generateJSCoverFilesForFileSystem(configuration.getDestDir(), configuration.getVersion());
        this.copyFolder(configuration.getSrcDir(), configuration.getDestDir());
    }

    private void copyFolder(File src, File dest) {
        String path = this.ioUtils.getRelativePath(src, this.configuration.getSrcDir());
        if (this.configuration.exclude(path)) {
            return;
        }
        if (src.isDirectory()) {
            String[] files;
            if (!dest.exists()) {
                dest.mkdirs();
            }
            for (String file : files = src.list()) {
                File srcFile = new File(src, file);
                File destFile = new File(dest, file);
                this.copyFolder(srcFile, destFile);
            }
        } else if (src.isFile() && src.toString().endsWith(".js") && !this.configuration.skipInstrumentation(path)) {
            this.instrumenterService.instrumentJSForFileSystem(this.configuration.getCompilerEnvirons(), src, dest, path, this.configuration.isIncludeBranch());
        } else {
            this.ioUtils.copy(src, dest);
        }
    }
}

