/*
 * Decompiled with CFR 0.152.
 */
package jscover.instrument;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import jscover.format.PlainFormatter;
import jscover.format.SourceFormatter;
import jscover.instrument.LineCountNodeVisitor;
import jscover.report.ScriptLinesAndSource;
import jscover.server.ConfigurationForServer;
import jscover.util.FileScanner;
import jscover.util.IoUtils;

public class UnloadedSourceProcessor {
    private ConfigurationForServer config;
    private SourceFormatter sourceFormatter = PlainFormatter.getInstance();
    private IoUtils ioUtils = IoUtils.getInstance();
    private FileScanner fileScanner;

    public UnloadedSourceProcessor(ConfigurationForServer config) {
        this.fileScanner = new FileScanner(config);
        this.config = config;
    }

    public List<ScriptLinesAndSource> getEmptyCoverageData(Set<String> urisAlreadyProcessed) {
        ArrayList<ScriptLinesAndSource> scripts = new ArrayList<ScriptLinesAndSource>();
        for (File file : this.fileScanner.getFiles(urisAlreadyProcessed)) {
            LineCountNodeVisitor visitor = new LineCountNodeVisitor(this.config.getCompilerEnvirons());
            String uri = this.ioUtils.getRelativePath(file, this.config.getDocumentRoot());
            String source = this.ioUtils.loadFromFileSystem(file);
            List<String> htmlLines = this.sourceFormatter.toHtmlLines(source);
            SortedSet<Integer> codeLines = visitor.getCodeLines(source);
            ScriptLinesAndSource script = new ScriptLinesAndSource("/" + uri, new ArrayList<Integer>(codeLines), htmlLines);
            scripts.add(script);
        }
        return scripts;
    }
}

