/*
 * Decompiled with CFR 0.152.
 */
package jscover.report;

public class BranchData {
    private int position;
    private int nodeLength;
    private String source;
    private int evalFalse;
    private int evalTrue;

    public BranchData(int position, int nodeLength, String source, int evalFalse, int evalTrue) {
        this.position = position;
        this.nodeLength = nodeLength;
        this.source = source;
        this.evalFalse = evalFalse;
        this.evalTrue = evalTrue;
    }

    public int getPosition() {
        return this.position;
    }

    public int getNodeLength() {
        return this.nodeLength;
    }

    public String getSource() {
        return this.source;
    }

    public int getEvalFalse() {
        return this.evalFalse;
    }

    public int getEvalTrue() {
        return this.evalTrue;
    }

    public void addCoverage(BranchData branchData) {
        if (this.position != branchData.position || this.nodeLength != branchData.nodeLength) {
            throw new IllegalStateException("Merging non-matching branch data");
        }
        this.evalFalse += branchData.evalFalse;
        this.evalTrue += branchData.evalTrue;
    }
}

