/*
 * Decompiled with CFR 0.152.
 */
package jscover.report;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import jscover.report.BranchData;
import jscover.report.CoverageData;
import jscover.report.ScriptLinesAndSource;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.json.JsonParser;

class JSONDataMerger {
    private Context cx = Context.enter();
    private JsonParser parser = new JsonParser(this.cx, this.cx.initStandardObjects());

    JSONDataMerger() {
    }

    public SortedMap<String, CoverageData> mergeJSONCoverageData(String data1, String data2) {
        SortedMap<String, CoverageData> map1 = this.jsonToMap(data1);
        SortedMap<String, CoverageData> map2 = this.jsonToMap(data2);
        for (String scriptName : map1.keySet()) {
            int i;
            if (!map2.containsKey(scriptName)) continue;
            CoverageData coverageData = (CoverageData)map1.get(scriptName);
            for (i = 0; i < coverageData.getCoverage().size(); ++i) {
                if (coverageData.getCoverage().get(i) == null) continue;
                coverageData.addCoverage(((CoverageData)map2.get(scriptName)).getCoverage().get(i), i);
            }
            for (i = 0; i < coverageData.getBranchData().size(); ++i) {
                List<BranchData> conditions = coverageData.getBranchData().get(i);
                if (conditions == null) continue;
                for (int j = 0; j < conditions.size(); ++j) {
                    if (conditions.get(j) == null) continue;
                    conditions.get(j).addCoverage(((CoverageData)map2.get(scriptName)).getBranchData().get(i).get(j));
                }
            }
        }
        for (String scriptName : map2.keySet()) {
            if (map1.containsKey(scriptName)) continue;
            map1.put(scriptName, (CoverageData)map2.get(scriptName));
        }
        return map1;
    }

    SortedMap<String, CoverageData> jsonToMap(String data) {
        TreeMap<String, CoverageData> map = new TreeMap<String, CoverageData>();
        try {
            NativeObject json = (NativeObject)this.parser.parseValue(data);
            for (Object scriptURI : json.keySet()) {
                NativeObject scriptData = (NativeObject)json.get(scriptURI);
                NativeArray lineCoverageArray = (NativeArray)scriptData.get("coverage");
                NativeArray sourceArray = (NativeArray)scriptData.get("source");
                NativeArray branchJSONArray = (NativeArray)scriptData.get("branchData");
                ArrayList<Integer> countData = new ArrayList<Integer>(lineCoverageArray.size());
                for (int i = 0; i < lineCoverageArray.size(); ++i) {
                    countData.add((Integer)lineCoverageArray.get(i));
                }
                ArrayList<String> sourceData = new ArrayList<String>(sourceArray.size());
                for (int i = 0; i < sourceArray.size(); ++i) {
                    sourceData.add((String)sourceArray.get(i));
                }
                ArrayList<List<BranchData>> branchLineArray = new ArrayList<List<BranchData>>();
                if (branchJSONArray != null) {
                    this.readBranchLines(branchJSONArray, branchLineArray);
                }
                map.put((String)scriptURI, new CoverageData(countData, sourceData, branchLineArray));
            }
        }
        catch (JsonParser.ParseException e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    private void readBranchLines(NativeArray branchJSONArray, List<List<BranchData>> branchLineArray) {
        for (int i = 0; i < branchJSONArray.size(); ++i) {
            ArrayList<BranchData> branchConditionArray = new ArrayList<BranchData>();
            branchLineArray.add(branchConditionArray);
            NativeArray conditionsJSON = (NativeArray)branchJSONArray.get(i);
            if (conditionsJSON == null) continue;
            this.readBranchCondition(branchConditionArray, conditionsJSON);
        }
    }

    private void readBranchCondition(List<BranchData> branchConditionArray, NativeArray conditionsJSON) {
        for (int j = 0; j < conditionsJSON.size(); ++j) {
            NativeObject conditionJSON = (NativeObject)conditionsJSON.get(j);
            if (conditionJSON == null) {
                branchConditionArray.add(null);
                continue;
            }
            int position = (Integer)conditionJSON.get("position");
            int nodeLength = (Integer)conditionJSON.get("nodeLength");
            String src = (String)conditionJSON.get("src");
            int evalFalse = (Integer)conditionJSON.get("evalFalse");
            int evalTrue = (Integer)conditionJSON.get("evalTrue");
            branchConditionArray.add(new BranchData(position, nodeLength, src, evalFalse, evalTrue));
        }
    }

    String toJSON(SortedMap<String, CoverageData> map) {
        StringBuilder json = new StringBuilder("{");
        int scriptCount = 0;
        for (String scriptURI : map.keySet()) {
            int i;
            StringBuilder coverage = new StringBuilder();
            StringBuilder source = new StringBuilder();
            StringBuilder branchData = new StringBuilder();
            CoverageData coverageData = (CoverageData)map.get(scriptURI);
            for (i = 0; i < coverageData.getCoverage().size(); ++i) {
                if (i > 0) {
                    coverage.append(",");
                }
                coverage.append(coverageData.getCoverage().get(i));
            }
            for (i = 0; i < coverageData.getSource().size(); ++i) {
                if (i > 0) {
                    source.append(",");
                }
                source.append("\"");
                source.append(ScriptRuntime.escapeString(coverageData.getSource().get(i)));
                source.append("\"");
            }
            this.addBranchData(branchData, coverageData);
            if (scriptCount++ > 0) {
                json.append(",");
            }
            String scriptJSON = "\"%s\":{\"coverage\":[%s],\"source\":[%s],\"branchData\":[%s]}";
            json.append(String.format(scriptJSON, scriptURI, coverage, source, branchData));
        }
        json.append("}");
        return json.toString();
    }

    private void addBranchData(StringBuilder branchData, CoverageData coverageData) {
        for (int i = 0; i < coverageData.getBranchData().size(); ++i) {
            List<BranchData> conditions;
            if (i > 0) {
                branchData.append(",");
            }
            if ((conditions = coverageData.getBranchData().get(i)).size() > 0) {
                branchData.append("[");
            } else {
                branchData.append("null");
            }
            this.addBranchConitions(branchData, conditions);
            if (conditions.size() <= 0) continue;
            branchData.append("]");
        }
    }

    private void addBranchConitions(StringBuilder branchData, List<BranchData> conditions) {
        for (int j = 0; j < conditions.size(); ++j) {
            BranchData branchObj;
            if (j > 0) {
                branchData.append(",");
            }
            if ((branchObj = conditions.get(j)) == null) {
                branchData.append("null");
                continue;
            }
            String branchJSON = "{\"position\":%d,\"nodeLength\":%d,\"src\":\"%s\",\"evalFalse\":%d,\"evalTrue\":%d}";
            String branchSource = ScriptRuntime.escapeString(branchObj.getSource());
            branchData.append(String.format(branchJSON, branchObj.getPosition(), branchObj.getNodeLength(), branchSource, branchObj.getEvalFalse(), branchObj.getEvalTrue()));
        }
    }

    public SortedMap<String, CoverageData> createEmptyJSON(List<ScriptLinesAndSource> scripts) {
        TreeMap<String, CoverageData> map = new TreeMap<String, CoverageData>();
        for (ScriptLinesAndSource script : scripts) {
            Integer[] lines = new Integer[script.getLines().get(script.getLines().size() - 1) + 1];
            for (int i = 0; i < script.getLines().size(); ++i) {
                lines[script.getLines().get((int)i).intValue()] = 0;
            }
            ArrayList<List<BranchData>> branchLineArray = new ArrayList<List<BranchData>>();
            CoverageData coverageData = new CoverageData(Arrays.asList(lines), script.getSource(), branchLineArray);
            map.put(script.getUri(), coverageData);
        }
        return map;
    }

    String toLCOV(File rootDir, SortedMap<String, CoverageData> map) {
        StringBuilder lcov = new StringBuilder();
        for (String scriptURI : map.keySet()) {
            lcov.append(String.format("SF:%s\n", rootDir.getAbsolutePath().replaceAll("\\\\", "/") + scriptURI));
            CoverageData coverageData = (CoverageData)map.get(scriptURI);
            for (int lineNumber = 0; lineNumber < coverageData.getCoverage().size(); ++lineNumber) {
                Integer count = coverageData.getCoverage().get(lineNumber);
                if (count == null) continue;
                lcov.append(String.format("DA:%d,%d\n", lineNumber, count));
            }
            lcov.append("end_of_record\n");
        }
        return lcov.toString();
    }
}

