/*
 * Decompiled with CFR 0.152.
 */
package jscover.server;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import jscover.Configuration;
import jscover.util.IoUtils;
import org.mozilla.javascript.CompilerEnvirons;

public class ConfigurationForServer
extends Configuration {
    public static final String HELP_PREFIX1 = "-h";
    public static final String HELP_PREFIX2 = "--help";
    public static final String DOC_ROOT_PREFIX = "--document-root=";
    public static final String PORT_PREFIX = "--port=";
    public static final String REPORT_DIR_PREFIX = "--report-dir=";
    public static final String NO_INSTRUMENT_PREFIX = "--no-instrument=";
    public static final String JS_VERSION_PREFIX = "--js-version=";
    public static final String PROXY_PREFIX = "--proxy";
    public static final String INCLUDE_UNLOADED_JS_PREFIX = "--include-unloaded-js";
    public static final String BRANCH_PREFIX = "--branch";
    private boolean showHelp;
    private boolean invalid;
    private boolean includeBranch = false;
    private File documentRoot = new File(System.getProperty("user.dir"));
    private Integer port = 8080;
    private final Set<String> noInstruments = new HashSet<String>();
    private File reportDir = new File(System.getProperty("user.dir"));
    private int JSVersion = 150;
    private boolean proxy;
    private CompilerEnvirons compilerEnvirons = new CompilerEnvirons();
    private boolean includeUnloadedJS;
    private IoUtils ioUtils = IoUtils.getInstance();

    public Boolean showHelp() {
        return this.showHelp;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public boolean isIncludeBranch() {
        return this.includeBranch;
    }

    public File getDocumentRoot() {
        return this.documentRoot;
    }

    public Integer getPort() {
        return this.port;
    }

    public File getReportDir() {
        return this.reportDir;
    }

    public int getJSVersion() {
        return this.JSVersion;
    }

    public boolean skipInstrumentation(String uri) {
        for (String noInstrument : this.noInstruments) {
            if (!uri.startsWith(noInstrument)) continue;
            return true;
        }
        return false;
    }

    public static ConfigurationForServer parse(String[] args) {
        ConfigurationForServer configuration = new ConfigurationForServer();
        for (String arg : args) {
            if (arg.startsWith("-ws")) continue;
            if (arg.equals(HELP_PREFIX1) || arg.equals(HELP_PREFIX2)) {
                configuration.showHelp = true;
                continue;
            }
            if (arg.startsWith(DOC_ROOT_PREFIX)) {
                configuration.documentRoot = new File(arg.substring(DOC_ROOT_PREFIX.length()));
                continue;
            }
            if (arg.startsWith(PORT_PREFIX)) {
                configuration.port = Integer.valueOf(arg.substring(PORT_PREFIX.length()));
                continue;
            }
            if (arg.equals(PROXY_PREFIX)) {
                configuration.proxy = true;
                continue;
            }
            if (arg.equals(INCLUDE_UNLOADED_JS_PREFIX)) {
                configuration.includeUnloadedJS = true;
                continue;
            }
            if (arg.startsWith(REPORT_DIR_PREFIX)) {
                configuration.reportDir = new File(arg.substring(REPORT_DIR_PREFIX.length()));
                configuration.reportDir.mkdirs();
                continue;
            }
            if (arg.startsWith(NO_INSTRUMENT_PREFIX)) {
                String uri = arg.substring(NO_INSTRUMENT_PREFIX.length());
                if (uri.startsWith("/")) {
                    uri = uri.substring(1);
                }
                configuration.noInstruments.add(uri);
                continue;
            }
            if (arg.startsWith(JS_VERSION_PREFIX)) {
                configuration.JSVersion = (int)(Float.valueOf(arg.substring(JS_VERSION_PREFIX.length())).floatValue() * 100.0f);
                continue;
            }
            if (arg.equals(BRANCH_PREFIX)) {
                configuration.includeBranch = true;
                continue;
            }
            configuration.showHelp = true;
            configuration.invalid = true;
        }
        configuration.compilerEnvirons.setLanguageVersion(configuration.JSVersion);
        return configuration;
    }

    public String getHelpText() {
        return this.ioUtils.toString(this.getClass().getResourceAsStream("help.txt"));
    }

    public CompilerEnvirons getCompilerEnvirons() {
        return this.compilerEnvirons;
    }

    public boolean isProxy() {
        return this.proxy;
    }

    public boolean isIncludeUnloadedJS() {
        return this.includeUnloadedJS && !this.proxy;
    }
}

