/*
 * Decompiled with CFR 0.152.
 */
package jscover.server;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jscover.instrument.InstrumenterService;
import jscover.instrument.UnloadedSourceProcessor;
import jscover.report.JSONDataSaver;
import jscover.report.ScriptLinesAndSource;
import jscover.server.ConfigurationForServer;
import jscover.server.HTTP_STATUS;
import jscover.server.HttpRequest;
import jscover.server.HttpServer;
import jscover.server.MIME;
import jscover.server.ProxyService;
import jscover.util.IoService;

public class InstrumentingRequestHandler
extends HttpServer {
    public static final String JSCOVERAGE_STORE = "/jscoverage-store";
    static Set<String> uris = new HashSet<String>();
    private ConfigurationForServer configuration;
    private IoService ioService = new IoService();
    private JSONDataSaver jsonDataSaver = new JSONDataSaver();
    private InstrumenterService instrumenterService = new InstrumenterService();
    private ProxyService proxyService = new ProxyService();
    private UnloadedSourceProcessor unloadedSourceProcessor;

    public InstrumentingRequestHandler(Socket socket, ConfigurationForServer configuration) {
        super(socket, configuration.getDocumentRoot(), configuration.getVersion());
        this.configuration = configuration;
        this.unloadedSourceProcessor = new UnloadedSourceProcessor(configuration);
    }

    @Override
    protected void handlePost(HttpRequest request, String data) {
        String uri = request.getPath();
        if (uri.startsWith(JSCOVERAGE_STORE)) {
            File reportDir = this.configuration.getReportDir();
            if (uri.length() > JSCOVERAGE_STORE.length()) {
                reportDir = new File(reportDir, uri.substring(JSCOVERAGE_STORE.length()));
            }
            try {
                List<ScriptLinesAndSource> unloadJSData = null;
                if (this.configuration.isIncludeUnloadedJS()) {
                    unloadJSData = this.unloadedSourceProcessor.getEmptyCoverageData(uris);
                }
                this.jsonDataSaver.saveJSONData(reportDir, data, unloadJSData);
                this.ioService.generateJSCoverFilesForWebServer(reportDir, this.configuration.getVersion());
                this.sendResponse(HTTP_STATUS.HTTP_OK, MIME.TEXT_PLAIN, "Coverage data stored at " + reportDir);
            }
            catch (Throwable t) {
                t.printStackTrace();
                String message = String.format("Error saving coverage data. Try deleting JSON file at %s\n", reportDir);
                this.sendResponse(HTTP_STATUS.HTTP_OK, MIME.TEXT_PLAIN, message);
            }
        } else if (this.configuration.isProxy()) {
            this.proxyService.handleProxyPost(request, data, this.os);
        } else {
            super.handlePost(request, data);
        }
    }

    @Override
    protected void handleGet(HttpRequest request) throws IOException {
        String uri = request.getPath();
        try {
            if (uri.equals("/jscoverage.js")) {
                this.sendResponse(HTTP_STATUS.HTTP_OK, request.getMime(), this.ioService.generateJSCoverageServerJS());
            } else if (uri.startsWith("/jscoverage.html")) {
                String reportHTML = this.ioService.generateJSCoverageHtml(this.configuration.getVersion());
                this.sendResponse(HTTP_STATUS.HTTP_OK, request.getMime(), reportHTML);
            } else if (uri.startsWith("/jscoverage")) {
                this.sendResponse(HTTP_STATUS.HTTP_OK, request.getMime(), this.ioService.getResourceAsStream(uri));
            } else if (uri.endsWith(".js") && !this.configuration.skipInstrumentation(uri.substring(1))) {
                String jsInstrumented;
                if (this.configuration.isProxy()) {
                    String originalJS = this.proxyService.getUrl(request.getUrl());
                    jsInstrumented = this.instrumenterService.instrumentJSForWebServer(this.configuration.getCompilerEnvirons(), originalJS, uri, this.configuration.isIncludeBranch());
                } else {
                    if (this.configuration.isIncludeUnloadedJS()) {
                        uris.add(uri.substring(1));
                    }
                    jsInstrumented = this.instrumenterService.instrumentJSForWebServer(this.configuration.getCompilerEnvirons(), new File(this.wwwRoot, uri), uri, this.configuration.isIncludeBranch());
                }
                this.sendResponse(HTTP_STATUS.HTTP_OK, MIME.JS, jsInstrumented);
            } else if (this.configuration.isProxy()) {
                this.proxyService.handleProxyGet(request, this.os);
            } else {
                super.handleGet(request);
            }
        }
        catch (Throwable e) {
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            this.sendResponse(HTTP_STATUS.HTTP_INTERNAL_SERVER_ERROR, MIME.TEXT_PLAIN, stringWriter.toString());
        }
    }

    @Override
    protected void handleHead(HttpRequest request) {
        if (this.configuration.isProxy()) {
            this.proxyService.handleProxyHead(request, this.os);
        } else {
            super.handleHead(request);
        }
    }
}

